DELIMITER $$
DROP PROCEDURE IF EXISTS V20240904160250__Alter_BuzzCampaignCodeGenerator $$
CREATE PROCEDURE V20240904160250__Alter_BuzzCampaignCodeGenerator()
BEGIN

IF EXISTS(SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='campaign_new' AND column_name='campaignCode') THEN
ALTER TABLE campaign_new 
RENAME COLUMN campaignCode TO code;
END IF;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

IF NOT EXISTS (select * from id_column_available where tableName='campaign_new' and columnName='code') THEN 
INSERT INTO id_column_available (tableName, columnName) VALUES('campaign_new','code');
END IF;

IF NOT EXISTS (select * from id_entity_setting where tableName='campaign_new' and idGenerationTable='campaign_new' and whetherFullyConfigurable=TRUE and dynanicFieldAvailable=FALSE and searchConfigCode is NULL) THEN 
INSERT INTO id_entity_setting ( tableName, idGenerationTable,whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate) 
VALUES('campaign_new','campaign_new',TRUE,FALSE,NULL,1,@currentTimeStamp);
END IF;
  
SET @idEntitySettingId=(SELECT MAX(id) FROM id_entity_setting);

IF NOT EXISTS (select * from id_definition where idEntitySettingId=@idEntitySettingId and idFormatType='ALPHA_NUMERIC' AND idColumn='code') THEN 
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION) 
VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','code',0,0,1,@currentTimeStamp,0);
END IF;


SET @idDefinitionId=(SELECT MAX(id) FROM id_definition);
IF NOT EXISTS (SELECT * FROM id_format where idDefinitionId=@idDefinitionId and seqNo=1) THEN 
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);
END IF;


SET @idFormat=(SELECT MAX(id) FROM id_format);
IF NOT EXISTS (SELECT * FROM id_format_alphanumeric WHERE id=@idFormat and prefix='CC' and suffix='' and startFrom=1) THEN
INSERT  INTO id_format_alphanumeric(id,prefix,suffix,startFrom) VALUES (@idFormat,'CC','',1);
END IF;


END $$
CALL V20240904160250__Alter_BuzzCampaignCodeGenerator() $$
DROP PROCEDURE IF EXISTS V20240904160250__Alter_BuzzCampaignCodeGenerator $$
DELIMITER ;