DELIMITER $$
DROP PROCEDURE IF EXISTS V20241002204535__Alter_AddColAdmissionConditionCSM $$
CREATE PROCEDURE V20241002204535__Alter_AddColAdmissionConditionCSM()
BEGIN

IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='admission_condition') THEN
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'admission_condition' AND COLUMN_NAME = 'isEnableForAdmissionAutomation')) THEN 
ALTER TABLE `admission_condition` 
ADD COLUMN `isEnableForAdmissionAutomation` BIT(1) DEFAULT 0;
END IF; 
END IF;

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
UPDATE `standard_master_items` SET `diaplayOrder` = '6' WHERE fieldLabel = 'CONDITION_TEXT' AND dbFieldName = 'conditionText';
END IF; 
SET SQL_SAFE_UPDATES=1;

IF EXISTS ((SELECT * FROM standard_master WHERE tableName = 'admission_condition')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'admission_condition');
INSERT INTO standard_master_items (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('isEnableForAdmissionAutomation','IS_ENABLE_FOR_ADM_AUTOMATION',@standardMasterId,'Boolean',NULL,5,0,NULL,NULL,NULL,0,0,1,1,now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' AND keyName = 'IS_ENABLE_FOR_ADM_AUTOMATION')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'IS_ENABLE_FOR_ADM_AUTOMATION', 'Is Enable For Admission Automation', 'Is Enable For Admission Automation',
'Is Geaktiveer vir Toelating Outomatisering','Được kích hoạt để tự động hóa tuyển sinh',now(),1);
END IF;

END $$
CALL V20241002204535__Alter_AddColAdmissionConditionCSM() $$
DROP PROCEDURE IF EXISTS V20241002204535__Alter_AddColAdmissionConditionCSM $$
DELIMITER ;