DELIMITER $$
DROP PROCEDURE IF EXISTS V20241003125051__Update_AddDataProviderInThesisNomiCancel $$
CREATE PROCEDURE V20241003125051__Update_AddDataProviderInThesisNomiCancel()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EVENT_STUDENT_NOMINATION_CANCELLED_RECIPIENTS')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EVENT_STUDENT_NOMINATION_CANCELLED_RECIPIENTS' limit 1);
UPDATE sql_dtprovider 
SET 
    sqlQuery = 'SELECT DISTINCT
        T3.userId AS ID,
        T4.printName AS STUDENT_NAME,
        T4.firstName AS FIRST_NAME,
        T5.remarks AS CANCELLATION_REMARKS,
        T7.emailId AS EMAIL_ID,
        T7.mobileNumber AS MOBILE_NO,
        T7.mobileCountryCode AS MOBILE_CODE,
        T6.academyName AS ACADEMY_NAME,
    T9.externalSysRefOne AS SU_NUMBER,
        T10.salutationName AS STUDENT_SALUTATION,
        concat(T11.programcode," ","/"," ",T11.programName) AS PROGRAM_CODE_NAME,
        T2.code AS ADMISSION_ID,
        (
            SELECT GROUP_CONCAT(sal.salutationName,"."," ",p.printName ORDER BY p.printName ASC SEPARATOR \', \')
            FROM thesis_management tm
            left join thesis_management_supervisor tms on tm.id=tms.thesisManagementId
            LEFT JOIN users u ON tms.supervisorId = u.id
            LEFT JOIN staffs s ON u.id = s.userId
            LEFT JOIN persons p ON s.personId = p.id
            LEFT JOIN salutations sal on p.salutationId=sal.id
            WHERE tm.id = T1.id
        ) AS SUPERVISORS,
        concat(T19.salutationName,"."," ",T16.printName) AS NOMINATOR,
        DATE_FORMAT(T5.lastUpdate, \'%d/%m/%Y\') AS SUBMISSION_DATE
    FROM
        thesis_management T1
            LEFT JOIN
        admission T2 ON T1.admissionId = T2.id
            LEFT JOIN
        students T3 ON T2.studentId = T3.userId
            LEFT JOIN
        users T4 ON T3.userId = T4.id
            LEFT JOIN
        thesis_management_status T5 ON  T1.id = T5.thesisManagementId
    		LEFT JOIN
        academy_location T6 ON T6.id = T2.academyLocationId
        LEFT JOIN
           persons T7 ON T7.id = T3.personId
          LEFT JOIN
    persons T9 on T3.personId=T9.id
    		LEFT JOIN
        salutations T10 on T9.salutationId=T10.id
    		LEFT JOIN
        programs T11 on T2.programId=T11.id
    		LEFT JOIN
        users T16 on T5.lastUpdatedBy=T16.id
			LEFT JOIN 
    staffs T17 ON T16.id = T17.userId
		LEFT JOIN
	persons T18 on T17.personId=T18.id
		LEFT JOIN 
    salutations T19 on T18.salutationId=T19.id
    WHERE T5.status=\'CANCELLED\' AND T3.userId in (namedParams) order by T5.lastUpdate desc limit 1',
    jsonString = '{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 1,
                "value": "printName",
                "resultKey": "STUDENT_NAME",
                "displayCode": "",
                "displayOrder": 0
            },
            {
                "id": 2,
                "value": "emailId",
                "resultKey": "EMAIL_ID",
                "displayCode": "",
                "displayOrder": 1
            },
            {
                "id": 3,
                "value": "mobileNumber",
                "resultKey": "MOBILE_NO",
                "displayCode": "",
                "displayOrder": 2
            },
    		{
                "id": 4,
                "value": "mobileCountryCode",
                "resultKey": "MOBILE_CODE",
                "displayCode": "",
                "displayOrder": 3
            },
    		{
                "id": 5,
                "value": "remarks",
                "resultKey": "CANCELLATION_REMARKS",
                "displayCode": "",
                "displayOrder": 4
            },
    		{
                "id": 6,
                "value": "academyName",
                "resultKey": "ACADEMY_NAME",
                "displayCode": "",
                "displayOrder": 5
            },
    		{
                "id": 7,
                "value": "externalSysRefOne",
                "resultKey": "SU_NUMBER",
                "displayCode": "",
                "displayOrder": 6
            },
    		{
                "id": 8,
                "value": "salutationName",
                "resultKey": "STUDENT_SALUTATION",
                "displayCode": "",
                "displayOrder": 7
            },
    		{
                "id": 9,
                "value": "programcode",
                "resultKey": "PROGRAM_CODE_NAME",
                "displayCode": "",
                "displayOrder": 8
            },
    		{
                "id": 10,
                "value": "code",
                "resultKey": "ADMISSION_ID",
                "displayCode": "",
                "displayOrder": 9
            },
    		{
                "id": 11,
                "value": "salutationName",
                "resultKey": "SUPERVISORS",
                "displayCode": "",
                "displayOrder": 10
            },
    		{
                "id": 12,
                "value": "printName",
                "resultKey": "NOMINATOR",
                "displayCode": "",
                "displayOrder": 11
            },
    		{
                "id": 13,
                "value": "lastUpdate",
                "resultKey": "CANCELLATION_DATE",
                "displayCode": "",
                "displayOrder": 12
            }
        ]
    }'
WHERE
    dataProviderId=@residenceRCPNT;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241003125051__Update_AddDataProviderInThesisNomiCancel () $$
DROP PROCEDURE IF EXISTS V20241003125051__Update_AddDataProviderInThesisNomiCancel $$
DELIMITER ;