DELIMITER $$
DROP PROCEDURE IF EXISTS V20241003153046__Alter_READMISSION_SR_EXECUTION $$
CREATE PROCEDURE V20241003153046__Alter_READMISSION_SR_EXECUTION()
BEGIN

IF EXISTS (select * from dtprovider where dataProviderName = "READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT") THEN 

SET @dataProviderId = (select id from dtprovider where dataProviderName = "READMISSION_SERVICE_REQUEST_EXECUTION_RECIPIENT");

update sql_dtprovider
SET sqlQuery = 
"SELECT DISTINCT
    T1.id AS ID,
    T5.printName AS PRINT_NAME,
    T5.firstName AS FIRST_NAME,
    T5.middleName AS MIDDLE_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T3.code AS STUDENT_ID,
    T5.emailId AS EMAIL_ID,
    T5.mobileCountryCode AS MOBILE_CODE,
    T5.mobileNumber AS MOBILE_NO,
    T5.externalSysRefOne AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1,
    T6.salutationName AS SERVICE_REQUEST_SALUTATION,
    T5.initials AS INITIALS,
    T14.itemValue AS ACADEMIC_YEAR,
    T13.displayName AS ACADEMY_LOCATION,
    T11.programNameToBePrint AS PROGRAM,
    T10.printName AS BATCH,
    T12.printName AS PERIOD,
    T7.reasonCode AS SERVICE_REQUEST_REASON,
    T1.remarks AS REMARKS,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T3.id) AS DEVICE_ID,
    (SELECT 
            GROUP_CONCAT(RO.itemValue)
        FROM
            execution_details ED
                RIGHT OUTER JOIN
            execution_details_readmission_outcome EDRO ON EDRO.executionDetailId = ED.id
                LEFT OUTER JOIN
            readmission_outcome RO ON EDRO.readmissionOutcomeId = RO.id
        WHERE
            ED.id = T1.id) AS READMISSION_OUTCOME,
    CURRENT_DATE AS 'CURRENT_DATE',
    DATE(T2.requestDate) AS REQUEST_CREATION_DATE,
    DATE(T1.executionDate) AS REQUEST_EXECUTION_DATE,
    T16.printName AS EXECUTED_BY,
    CONCAT(T19.displayName, ' - ', T19.locationName) AS INTENDED_FACULTY_OF_STUDY,
    CONCAT(T20.programCode, ' / ', T20.programName) AS INTENDED_PROGRAM_OF_STUDY
FROM
    execution_details T1
        LEFT OUTER JOIN
    service_requests T2 ON T2.id = T1.serviceRequestId
        LEFT OUTER JOIN
    readmission_request_details T18 ON T18.serviceRequestId = T2.id
        LEFT OUTER JOIN
    academy_location T19 ON T18.intendedALOfStudyId = T19.id
        LEFT OUTER JOIN
    programs T20 ON T18.intendedProgramOfStudyId = T20.id
        LEFT OUTER JOIN
    users T3 ON T3.id = T2.requester
        LEFT OUTER JOIN
    students T4 ON T4.userId = T3.id
        LEFT OUTER JOIN
    persons T5 ON T5.id = T4.personId
        LEFT OUTER JOIN
    salutations T6 ON T6.id = T5.salutationId
        LEFT OUTER JOIN
    closure_reason T7 ON T7.id = T1.closureReasonId
        LEFT OUTER JOIN
    admission T8 ON T8.studentId = T3.id
        LEFT OUTER JOIN
    program_batch_students T9 ON T9.admissionId = T8.id
        AND T9.exitDate IS NULL
        AND T9.isPeriodCompleted = FALSE
        LEFT OUTER JOIN
    batches T10 ON T10.id = T9.programBatchId
        AND T10.programId = T2.currentProgram
        LEFT OUTER JOIN
    programs T11 ON T11.id = T10.programId
        LEFT OUTER JOIN
    prog_batch_period_config T12 ON T12.id = T9.progBatchPeriodConfigId
        LEFT OUTER JOIN
    academy_location T13 ON T13.id = T11.academyLocationId
        LEFT OUTER JOIN
    academic_term T14 ON T14.id = T12.academicTermId
        LEFT OUTER JOIN
    multi_language ml ON ml.id = T5.correspondence_language
        LEFT OUTER JOIN
    users T16 ON T1.lastUpdatedBy = T16.id
WHERE
    T1.id IN (namedParams)
GROUP BY T1.id
",
jsonString =
'
{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },       
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
		{
            "id": 4,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "externalSysRefOne",
            "resultKey": "STUDENT_EXTERNAL_REFERENCE_NUMBER_1",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "salutationName",
            "resultKey": "SERVICE_REQUEST_SALUTATION",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "initials",
            "resultKey": "INITIALS",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "itemValue",
            "resultKey": "ACADEMIC_YEAR",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "printName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 11
        },{
            "id": 13,
            "value": "printName",
            "resultKey": "PERIOD",
            "displayCode": "",
            "displayOrder": 12
		},{
            "id": 14,
            "value": "reasonCode",
            "resultKey": "SERVICE_REQUEST_REASON",
            "displayCode": "",
            "displayOrder": 13
		},{
            "id": 15,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 14
        },{
            "id": 16,
            "value": "readmissionOutcome",
            "resultKey": "READMISSION_OUTCOME",
            "displayCode": "",
            "displayOrder": 15
        },{
            "id": 17,
            "value": "currentDate",
            "resultKey": "CURRENT_DATE",
            "displayCode": "",
            "displayOrder": 16
        },{
            "id": 18,
            "value": "requestCreationDate",
            "resultKey": "REQUEST_CREATION_DATE",
            "displayCode": "",
            "displayOrder": 17
        },{
            "id": 19,
            "value": "requestExecutionDate",
            "resultKey": "REQUEST_EXECUTION_DATE",
            "displayCode": "",
            "displayOrder": 18
        },{
            "id": 20,
            "value": "executedBy",
            "resultKey": "EXECUTED_BY",
            "displayCode": "",
            "displayOrder": 19
        },{
            "id": 21,
            "value": "intendedFacultyOfStudy",
            "resultKey": "INTENDED_FACULTY_OF_STUDY",
            "displayCode": "",
            "displayOrder": 20
        },{
            "id": 22,
            "value": "intendedProgramOfStudy",
            "resultKey": "INTENDED_PROGRAM_OF_STUDY",
            "displayCode": "",
            "displayOrder": 21
        }
    ]
 }
'
WHERE dataProviderId = @dataProviderId;
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='EXECUTED_BY' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','EXECUTED_BY','Executed By','Executed By','Thực hiện bởi','Uitgevoer deur',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='REQUEST_EXECUTION_DATE' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','REQUEST_EXECUTION_DATE','Request Execution Date','Request Execution Date','Yêu cầu ngày thực hiện','Versoek Uitvoeringsdatum',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='REQUEST_CREATION_DATE' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','REQUEST_CREATION_DATE','Request creation Date','Request creation Date','Versoek skeppingsdatum','Ngày tạo yêu cầu',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='CURRENT_DATE' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','CURRENT_DATE','Current Date','Current Date','Huidige datum','Ngày hiện tại',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='READMISSION_OUTCOME' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','READMISSION_OUTCOME','Readmission Outcome','Readmission Outcome','Hertoelatingsuitkoms','Kết quả tái nhập viện',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='INTENDED_PROGRAM_OF_STUDY' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','INTENDED_PROGRAM_OF_STUDY','Intended program of study','Intended program of study','Beoogde studieprogram','Chương trình học dự kiến',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='INTENDED_FACULTY_OF_STUDY' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','INTENDED_FACULTY_OF_STUDY','Intended Faculty of study','Intended Faculty of study','Beoogde Fakulteit van studie','Khoa dự định học',now(),1);
END IF; 



END $$
CALL V20241003153046__Alter_READMISSION_SR_EXECUTION() $$
DROP PROCEDURE IF EXISTS V20241003153046__Alter_READMISSION_SR_EXECUTION $$
DELIMITER ;