DELIMITER $$
DROP PROCEDURE IF EXISTS V20241008104922__Create_SubstityFacultyTable $$
CREATE PROCEDURE V20241008104922__Create_SubstityFacultyTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='substitute_faculty' )) THEN 
CREATE TABLE `substitute_faculty` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `facultyId` BIGINT(20) NULL DEFAULT NULL,
  `academyLocationId` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  
 CONSTRAINT RefuserSubstituteFaculty FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefALSubstituteFaculty FOREIGN KEY (academyLocationId) REFERENCES academy_location(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefstaffSubstituteFaculty FOREIGN KEY (facultyId) REFERENCES staffs(userId)
	ON DELETE RESTRICT ON UPDATE RESTRICT
);

END IF; 


END $$
CALL V20241008104922__Create_SubstityFacultyTable () $$ 
DROP PROCEDURE IF EXISTS V20241008104922__Create_SubstityFacultyTable $$ 
DELIMITER ;