DELIMITER $$
DROP PROCEDURE IF EXISTS V20241009151832__Alter_FlywireStandardPaymentGateway $$
CREATE PROCEDURE V20241009151832__Alter_FlywireStandardPaymentGateway()
BEGIN


IF EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_flywire_id_idx' AND table_name='flywire')  then
ALTER TABLE flywire DROP FOREIGN KEY fk_flywire_id_idx;
END IF;

IF EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and column_name='standardPaymentGatewayId' and table_name='flywire' and index_name='fk_flywire_id_idx') then
ALTER TABLE flywire DROP index fk_flywire_id_idx;
END IF;

IF EXISTS (SELECT * FROM information_schema.columns where table_schema=database() and column_name='academyLocation' and table_name='flywire') then
ALTER TABLE flywire DROP COLUMN academyLocation;
END IF;

IF EXISTS (SELECT * FROM information_schema.columns where table_schema=database() and column_name='standardPaymentGatewayId' and table_name='flywire') then
ALTER TABLE flywire CHANGE COLUMN standardPaymentGatewayId academyLocationId BIGINT NULL DEFAULT NULL;
END IF;

IF EXISTS (SELECT * FROM information_schema.columns where table_schema=database() and column_name='payerId' and table_name='flywire') then
ALTER TABLE flywire CHANGE COLUMN payerId payerId VARCHAR(255) NOT NULL;
END IF;

IF NOT EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and table_name='flywire' and index_name='fk_flywire_academyLocation_id') then
ALTER TABLE flywire ADD INDEX fk_flywire_academyLocation_id (academyLocationId);
END IF;

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_flywire_academyLocation_id' AND table_name='flywire') then
ALTER TABLE flywire ADD CONSTRAINT fk_flywire_academyLocation_id
  FOREIGN KEY (academyLocationId)
  REFERENCES academy_location (id)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF;

  SET @ItemsMaxId=(select id from standard_master where tableName = 'flywire');
  UPDATE standard_master_items SET fieldLabel = 'ACADEMY_LOCATION'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'academyLocation');
  UPDATE standard_master_items SET fieldLabel = 'PAYER_ID'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'payerId');
   UPDATE standard_master_items SET fieldLabel = 'RECIPIENT'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'recipient');
    UPDATE standard_master_items SET fieldLabel = 'ENVIRONMENT'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'environment');
     UPDATE standard_master_items SET fieldLabel = 'ORDER_URL'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'orderUrl');
      UPDATE standard_master_items SET fieldLabel = 'COUNTRY'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'country');
      UPDATE standard_master_items SET fieldLabel = 'STATE'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'state');
      UPDATE standard_master_items SET fieldLabel = 'X_AUTHENTICATION'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'xAuthenticationKey');
      UPDATE standard_master_items SET fieldLabel = 'LOCALE'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'locale');
       UPDATE standard_master_items SET fieldLabel = 'PROVIDER'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'provider');
   UPDATE standard_master_items SET fieldType = 'Varchar'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'payerId') ;
UPDATE standard_master_items SET whetherForeignKey = b'1', fkTable = 'academy_location', fkFieldName = 'id', fkDisplayField = 'academyLocationName'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'academyLocation') ;

END $$
CALL V20241009151832__Alter_FlywireStandardPaymentGateway() $$
DROP PROCEDURE IF EXISTS V20241009151832__Alter_FlywireStandardPaymentGateway $$
DELIMITER ;