DELIMITER $$
DROP PROCEDURE IF EXISTS V20241014154857__Alter_AlterCourseCoveragePlan $$
CREATE PROCEDURE V20241014154857__Alter_AlterCourseCoveragePlan()
BEGIN

IF NOT EXISTS (SELECT column_name 
                   FROM INFORMATION_SCHEMA.COLUMNS 
                   WHERE table_schema = DATABASE() 
                     AND table_name = 'course_coverage_plan' 
                     AND column_name = 'substituteFacultyId') THEN
                     
        -- Add the column
        ALTER TABLE `course_coverage_plan` 
        ADD COLUMN `substituteFacultyId` BIGINT(20) AFTER `id`;
        
        -- Add the index
        ALTER TABLE `course_coverage_plan`
        ADD INDEX `fk_course_coverage_plan_facu1_idx` (`substituteFacultyId` ASC);
        
        -- Add the foreign key constraint
        ALTER TABLE `course_coverage_plan` 
        ADD CONSTRAINT `fk_course_coverage_plan_facu1`
          FOREIGN KEY (`substituteFacultyId`)
          REFERENCES `staffs` (`userId`)
          ON DELETE RESTRICT
          ON UPDATE RESTRICT;
    END IF;

END $$
CALL V20241014154857__Alter_AlterCourseCoveragePlan() $$
DROP PROCEDURE IF EXISTS V20241014154857__Alter_AlterCourseCoveragePlan $$
DELIMITER ;