DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseStMappingbb $$
CREATE PROCEDURE fatchCourseStMappingbb()
BEGIN
   SELECT 
    func_inc_var_session_rec() AS `Id`,
    usr.id AS 'studentId',
    usr.code AS 'studentCode',
    adm.id AS 'admissionId',
    adm.code AS 'admissionCode',
    pbpc.id AS 'periodId',
    cv.id AS 'courseVariantsId',
    bum.blackboardUserId AS 'blackboardUserId',
    bcm.blackboardCourseId AS 'blackboardCourseId'
    FROM student_course_enrollment scm
    JOIN admission adm ON scm.admissionId = adm.id
    JOIN users usr ON usr.id = adm.studentId
    JOIN prog_batch_period_config pbpc ON scm.programBatchPeriodConfigId = pbpc.id
    JOIN program_batch_students pbs on pbs.admissionId=scm.admissionId 
	JOIN prog_batch_seat_config as pbsc ON pbs.progBatchSeatConfigId=pbsc.id
	JOIN seat_types as seatType ON (seatType.id=pbsc.seatTypeId and seatType.seatName not in(select value from drop_down where type='Blackboard_Seattype_SkipRules'))    
    JOIN bill_header bh ON scm.billId = bh.id 
    JOIN course_variants cv ON  scm.courseVarientId = cv.id
    JOIN blackboard_user_mapping bum ON  bum.academiaUserId = usr.id
    JOIN blackboard_course_mapping bcm ON  bcm.academiaCourseVariantId = cv.id 
    LEFT JOIN blackboard_user_course_membership_mapping bucmm ON  bucmm.academiaUserId = usr.id 
    AND bucmm.academiaCourseVariantId = cv.id
    WHERE bucmm.id is null and pbs.exitDate is null and  pbs.promotionEnrollmentStatus = 'ENROLLED' 
    and bh.billStatus in ('SETTLED','PARTLY_SETTLED') 
    
    UNION
    
    SELECT 
    func_inc_var_session_rec() AS `Id`,
    usr.id AS 'studentId',
    usr.code AS 'studentCode',
    adm.id AS 'admissionId',
    adm.code AS 'admissionCode',
    pbpc.id AS 'periodId',
    cv.id AS 'courseVariantsId',
    bum.blackboardUserId AS 'blackboardUserId',
    bcm.blackboardCourseId AS 'blackboardCourseId'
    FROM student_course_enrollment scm
    JOIN admission adm ON scm.admissionId = adm.id
    JOIN users usr ON usr.id = adm.studentId
    JOIN prog_batch_period_config pbpc ON scm.programBatchPeriodConfigId = pbpc.id
    JOIN program_batch_students pbs on pbs.admissionId=scm.admissionId 
	JOIN prog_batch_seat_config as pbsc ON pbs.progBatchSeatConfigId=pbsc.id
	JOIN seat_types as seatType ON (seatType.id=pbsc.seatTypeId and seatType.seatName in(select value from drop_down where type='Blackboard_Seattype_SkipRules'))    
    JOIN course_variants cv ON  scm.courseVarientId = cv.id
    JOIN blackboard_user_mapping bum ON  bum.academiaUserId = usr.id
    JOIN blackboard_course_mapping bcm ON  bcm.academiaCourseVariantId = cv.id 
    LEFT JOIN blackboard_user_course_membership_mapping bucmm ON  bucmm.academiaUserId = usr.id 
    AND bucmm.academiaCourseVariantId = cv.id
    WHERE bucmm.id is null and pbs.exitDate is null and  pbs.promotionEnrollmentStatus = 'ENROLLED';    
END $$ 
DELIMITER ;