DELIMITER $$
DROP PROCEDURE IF EXISTS d2l5Offerings $$
CREATE PROCEDURE d2l5Offerings()
BEGIN
SELECT
'type', 'action', 'code', 'name', 'start_date', 'end_date', 'is_active', 'department_code', 'template_code', 'semester_code', 'offering_code', 'custom_code'
 UNION
SELECT
'course offering', 'UPDATE', cv.courseVariantCode, cv.courseVariantDescription, period.programPeriodStart, period.programPeriodEnd, if(period.programPeriodEnd>= now(), 1,0),concat(al.academyCode,'-',al.locationCode), courses.courseCode, concat(programs.programCode,'-',batches.batchName,'-',period.programPeriodName), concat(programs.programCode,'-',batches.batchName,'-',period.programPeriodName), courses.courseCode
from program_batch_course_param as param
join course_variants as cv on cv.id=param.courseVarientId
join academy_location as al on cv.academyLocationId= al.id
join courses on cv.courseId=courses.id
join prog_batch_period_config as period on param.progBatchPeriodConfigId= period.id
JOIN academic_term ON period.academicTermId=academic_term.id AND academic_term.whetherCurrentAcademicTerm=true
join batches on period.programBatchId=batches.id
join programs on batches.programId=programs.id;
END $$
DELIMITER ;