DELIMITER $$
DROP PROCEDURE IF EXISTS V20241106175850__Create_progressionPanelDecisionTemplate $$
CREATE PROCEDURE V20241106175850__Create_progressionPanelDecisionTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='progression_panel_decision_template')) THEN 
CREATE TABLE `progression_panel_decision_template` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT NULL,
  `studentId` BIGINT NULL,
  `decisionId` BIGINT NULL,
  `remarks` VARCHAR(45) NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_ProgressionPanelDecisionTemplate_admission_idx` (`admissionId` ASC) ,
  INDEX `fk_ProgressionPanelDecisionTemplate_student_idx` (`studentId` ASC) ,
  INDEX `fk_ProgressionPanelDecisionTemplate_decision_idx` (`decisionId` ASC) ,
  CONSTRAINT `fk_ProgressionPanelDecisionTemplate_admission`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_ProgressionPanelDecisionTemplate_student`
    FOREIGN KEY (`studentId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_ProgressionPanelDecisionTemplate_decision`
    FOREIGN KEY (`decisionId`)
    REFERENCES `progression_status` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20241106175850__Create_progressionPanelDecisionTemplate () $$ 
DROP PROCEDURE IF EXISTS V20241106175850__Create_progressionPanelDecisionTemplate $$ 
DELIMITER ;