DELIMITER $$
DROP PROCEDURE IF EXISTS V20241128171747__Create_IITSLTranscriptReport $$
CREATE PROCEDURE V20241128171747__Create_IITSLTranscriptReport()
BEGIN

set @iITSL = (select max(id) from report_type where typeName='Mark Sheet' );
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'IITSL_TRANSCRIPT')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`,`documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@iITSL, 'IITSL_TRANSCRIPT', 'IITSL Transcript', 'IITSL_TRANSCRIPT.png', 'CommonReport_IITSL_TRANSCRIPT.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'IITSL_TRANSCRIPT.jasper', 'AcademiaLogo.png');
END IF; 


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'IITSL_TRANSCRIPT')) THEN 
set @tempId = (select max(id)  from report_template where templateCode ='IITSL_TRANSCRIPT');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_NAME', 'Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_DOB')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DOB', 'Date of Birth', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_STU_REF')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_STU_REF', 'Student Reference', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_LVL_COMPLET')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_LVL_COMPLET', 'Level completed', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_INT_QUALIFICATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_INT_QUALIFICATION', 'Intended Qualification', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_LANGUGE_INST')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_LANGUGE_INST', 'Language of Instruction', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_AWARD_CLASS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_AWARD_CLASS', 'Award Class', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_MODE_OF_STUDY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MODE_OF_STUDY', 'Mode of study', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_RECORD_ACHIV')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_RECORD_ACHIV', 'Record of Learning and Achievement', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_LEVEL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_LEVEL', 'Level', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_MODULE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MODULE_CODE', 'Module Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_MODULE_TITLE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MODULE_TITLE', 'Module Title', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_CREDIT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CREDIT', 'Credit', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_ACADEMIC_YEAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_ACADEMIC_YEAR', 'Academic Year', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_RESULT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_RESULT', 'Results', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_ATTEMPT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_ATTEMPT', 'Attempt', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_MARK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_MARK', 'Mark', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_CVMP')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_CVMP', 'Credit value of modules Passed', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_KP')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_KP', 'Kaushalya Pathberiya', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_SAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_SAR', 'Senior Assistant Registrar', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempId and keyValue='TRANS_DATE_ISSUE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DATE_ISSUE', 'Date of issue', '1', now());
END IF;



END $$
CALL V20241128171747__Create_IITSLTranscriptReport () $$ 
DROP PROCEDURE IF EXISTS V20241128171747__Create_IITSLTranscriptReport $$ 
DELIMITER ;