DELIMITER $$
DROP PROCEDURE IF EXISTS V20241209165619__Create_ServiceRequestForEscalateApprover $$
CREATE PROCEDURE V20241209165619__Create_ServiceRequestForEscalateApprover()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='Quick Comment For Escalated Approver')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='SERVICE_REQUEST');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'Quick Comment For Escalated Approver');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='Quick Comment For Escalated Approver');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'QUICK_COMMENT_FOR_ESCALATED_APPROVAR', 'Quick Comment For Escalated Approver', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Quick Comment For Escalated Approver');
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

  -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'QUICK_COMMENT_FOR_ESCALATED_APPROVAR_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'QUICK_COMMENT_FOR_ESCALATED_APPROVAR_RECIPIENT', 'SQL');

-- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QUICK_COMMENT_FOR_ESCALATED_APPROVAR_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'QUICK_COMMENT_FOR_ESCALATED_APPROVAR_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QUICK_COMMENT_FOR_ESCALATED_APPROVAR_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='QUICK_COMMENT_FOR_ESCALATED_APPROVAR_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
  -- Setting the query for the Student distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QUICK_COMMENT_FOR_ESCALATED_APPROVAR_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM quick_comment T1 WHERE T1.id IN (namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QUICK_COMMENT_FOR_ESCALATED_APPROVAR_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 'SELECT 
	 T1.id AS ID,
    T6.firstName AS FIRST_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T2.documentName AS DOCUMENT_NAME,
    T1.comments AS COMMENTS
FROM 
    quick_comment T1
JOIN 
    documents T2 ON T1.id = T2.id
JOIN
    service_requests T3 ON T1.serviceRequestId = T3.id
JOIN
    approval_details T4 on T3.id = T4.serviceRequestId
JOIN
    staffs T5 on T4.escalatedApproverUserId = T5.userId
JOIN
    users T6 on T6.id = T5.userId
WHERE 
     T1.id IN (namedParams)',' {
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "documentName",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "comments",
            "resultKey": "COMMENTS",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },       
        {
            "id": 5,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        }
    ]
 }
');

 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='QUICK_COMMENT_FOR_ESCALATED_APPROVAR_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='QUICK_COMMENT_FOR_ESCALATED_APPROVAR');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='Quick Comment For Escalated Approver');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='QUICK_COMMENT_FOR_ESCALATED_APPROVAR_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Quick Comment For Escalated Approver',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Quick Comment For Escalated Approver',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Quick Comment For Escalated Approver','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','Quick Comment For Escalated Approver','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+4,@msgtemplateconfigId+1,'6','Quick Comment For Escalated Approver','');

END IF; 

END $$
CALL V20241209165619__Create_ServiceRequestForEscalateApprover () $$ 
DROP PROCEDURE IF EXISTS V20241209165619__Create_ServiceRequestForEscalateApprover $$ 
DELIMITER ;