DELIMITER $$
DROP EVENT IF EXISTS V20241210105301__Update_timestamp_default $$
CREATE EVENT V20241210105301__Update_timestamp_default
ON SCHEDULE AT CURRENT_TIMESTAMP() + INTERVAL 3 HOUR
DO
BEGIN

    -- Approval Details --
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'approval_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE approval_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Change Exam Centre Request Details
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'change_exam_centre_request_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE change_exam_centre_request_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Change Exam Date Request Details (expectedDate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'change_exam_date_request_details' 
          AND COLUMN_NAME = 'expectedDate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE change_exam_date_request_details 
        MODIFY COLUMN expectedDate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Change Exam Date Request Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'change_exam_date_request_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE change_exam_date_request_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Course Evaluation Que Paper (tillDate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'course_evaluation_que_paper' 
          AND COLUMN_NAME = 'tillDate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE course_evaluation_que_paper 
        MODIFY COLUMN tillDate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Course Evaluation Que Paper (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'course_evaluation_que_paper' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE course_evaluation_que_paper 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Employee Leave Request Detail (toDate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'employee_leave_request_detail' 
          AND COLUMN_NAME = 'toDate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE employee_leave_request_detail 
        MODIFY COLUMN toDate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Enq Default User (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'enq_default_user' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE enq_default_user 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Exam Date Change Req Types (expectedExamDate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'exam_date_change_req_types' 
          AND COLUMN_NAME = 'expectedExamDate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE exam_date_change_req_types 
        MODIFY COLUMN expectedExamDate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Exam Leave Request Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'exam_leave_request_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE exam_leave_request_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Exam Withdrawal Request Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'exam_withdrawal_request_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE exam_withdrawal_request_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Execution Details (handoverDate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'execution_details' 
          AND COLUMN_NAME = 'handoverDate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE execution_details 
        MODIFY COLUMN handoverDate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Execution Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'execution_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE execution_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Followup Details (actualFollowupDate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'followup_details' 
          AND COLUMN_NAME = 'actualFollowupDate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE followup_details 
        MODIFY COLUMN actualFollowupDate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Followup Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'followup_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE followup_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Leave Transaction (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'leave_transaction' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE leave_transaction 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;


    -- Quota Validity (validTill)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'quota_validity' 
          AND COLUMN_NAME = 'validTill' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE quota_validity 
        MODIFY COLUMN validTill TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Quota Validity (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'quota_validity' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE quota_validity 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Re Exam Request Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 're_exam_request_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE re_exam_request_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Scholarship Request Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'scholarship_request_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE scholarship_request_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Service SW Request Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'service_sw_request_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE service_sw_request_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Admission Enq Details Buzz (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'admission_enq_details_buzz' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE admission_enq_details_buzz 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;
    
    -- Debarment Request Details (lastUpdate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'debarment_request_details' 
          AND COLUMN_NAME = 'lastUpdate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE debarment_request_details 
        MODIFY COLUMN lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

    -- Debarment Request Details (toDate)
    IF EXISTS (
        SELECT 1 
        FROM INFORMATION_SCHEMA.COLUMNS 
        WHERE TABLE_NAME = 'debarment_request_details' 
          AND COLUMN_NAME = 'toDate' 
          AND COLUMN_DEFAULT = '0000-00-00 00:00:00'
    ) THEN
        ALTER TABLE debarment_request_details 
        MODIFY COLUMN toDate TIMESTAMP DEFAULT CURRENT_TIMESTAMP;
    END IF;

END $$
DELIMITER ;
