DELIMITER $$
DROP PROCEDURE IF EXISTS V20241218104939__Create_journeyAuditAddedStatusDetails $$
CREATE PROCEDURE V20241218104939__Create_journeyAuditAddedStatusDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='journey_added_status_audit_details')) THEN
CREATE TABLE `journey_added_status_audit_details` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `studentJourneyAddedStatusId` BIGINT(20) NOT NULL,
  `studentJourneyAuditDetailId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_journey_added_status_audit_idx` (`studentJourneyAddedStatusId` ASC),
  INDEX `fk_journey_audit_details_idx` (`studentJourneyAuditDetailId` ASC),
  INDEX `fk_journey_added_status_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_student_journey_added_status_audit_details_id`
    FOREIGN KEY (`studentJourneyAddedStatusId`)
    REFERENCES `student_journey_added_status` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_journey_audit_added_status_details_studentJourneyid`
    FOREIGN KEY (`studentJourneyAuditDetailId`)
    REFERENCES `student_journey_audit_details` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_student_journey_added_status_audit_details_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF;  
END $$
CALL V20241218104939__Create_journeyAuditAddedStatusDetails () $$ 
DROP PROCEDURE IF EXISTS V20241218104939__Create_journeyAuditAddedStatusDetails $$ 
DELIMITER ;