
DROP procedure IF EXISTS `exam_result_declaration_job`;

DELIMITER $$
CREATE PROCEDURE `exam_result_declaration_job`()
BEGIN
declare recordLimit int;
set recordLimit := 5000;

select 
result.id as id,
null as examResultEventId,
cv.id as courseVariantId,
sections.id as sectionId,
admission.id as admissionId,
admission.code as admissionCode,
users.code as studentCode,
plan.id as evaluationPlanId,
plan.evaluationPlanNumber as evaluationPlanNumber,
plan.evaluationPlanType as evaluationPlanType,
plan.markingMethod as markingMethod,
plan.isLongDistance as isLongDistanceForTable,
sections.sectionCode as sectionName,
period.id as periodId,
period.printName as periodName,
batches.id as batchId,
batches.printName as batchName,
programs.id as programId,
programs.programNameToBePrint as programName,
cv.courseVariantCode as courseVariantCode,
courses.id as courseId,
courses.courseCode as courseCode,
courses.nameToBePrinted as courseName,
param.courseCredits as courseCredits,
plan.roundingMode as roundingMode,
plan.roundingCount as roundingCount,
plan.whetherDroolApplicable as whetherDroolApplicable,
plan.resultCalculationStatus as resultCalculationStatus,
plan.whetherConsiderAbsentAsFail as whetherConsiderAbsentAsFail,
plan.considerOpenForMarkEntry as considerOpenForMarkEntry,
drool_rules.id as droolRuleId,
drool_rules.droolCode as droolCode,
al.terminology as terminology,
type.id as ruleAppliedForLevelOneId,
subType.id as ruleAppliedForLevelTwoId,
method.id as ruleAppliedForLevelThreeId,
event.id as ruleAppliedForLevelFourId,
event.weightage as weightage,
event.whetherATKTRequired as whetherATKTRequired,
event.whetherDetailSeqEquivalent as whetherDetailSeqEquivalent,
param.courseGradeType as paramGradeType,
null as whetherDetention,
result.calculationPriority,
result.markEntryDate as markEntryDate
from examination_result as result
left join course_variants as cv on result.courseVariantId=cv.id
left join evaluation_type_course as type_course on cv.id=type_course.courseVariantId and type_course.periodId=result.periodId and type_course.sectionId=result.sectionId
left join course_variant_event_mapping as event_mapping on type_course.id=event_mapping.evaluationTypeCourseId and event_mapping.eventId=result.evaluationDetailSequenceId
join eval_seq_detail as event on result.evaluationDetailSequenceId=event.id
left join courses on cv.courseId=courses.id
join sections on result.sectionId=sections.id
join prog_batch_period_config as period on result.periodId=period.id
join admission on result.admissionId=admission.id
join users on admission.studentId=users.id
join batches on period.programBatchId=batches.id
join programs on batches.programId=programs.id
join academy_location as al on programs.academyLocationId=al.id
left join program_batch_course_param as param on type_course.programBatchCourseParamId=param.id
join evaluation_sequence as method on event.evalSequenceId=method.id
join evaluation_plan_level_two as subType on method.evalPlanLevelTwoId=subType.id
join evaluation_plan_level_one as type on subType.evalPlanLevelOneId=type.id
join evaluation_plan as plan on type.evaluationPlanId=plan.id
left join drool_rules on plan.droolId=drool_rules.id
left join evaluation_type_program as typeProgram on typeProgram.evaluationPlanId=plan.id and typeProgram.programBatchPeriodConfigId=result.periodId and typeProgram.sectionId=result.sectionId
left join course_variant_event_mapping as other_event_mapping on other_event_mapping.evaluationTypeProgramId=typeProgram.id and other_event_mapping.eventId=event.id
where (result.whetherSpecialGrade is null or result.whetherSpecialGrade = false) 
and (cv.id is null or cv.whetherExamCompleted = false)
and (plan.status = 'PENDING' or plan.status = 'MARK_TO_GRADE_TRANFORMED') 
and (event_mapping.eventStatus='CONDUCTED' or other_event_mapping.eventStatus='CONDUCTED')
and ((plan.whetherDroolApplicable = true and plan.resultCalculationStatus='RESULT_DECLARED' and drool_rules.id is not null and event.whetherDetailSeqEquivalent=true and result.calculationDone=true and (result.examResultStatus is not null or result.whetherExamAttended = false or plan.remarkOnlyAssessment = true or type.remarkOnlyAssessment=true or subType.remarkOnlyAssessment=true or method.remarkOnlyAssessment=true)) or (plan.markingMethod='INDIVIDUAL' and event_mapping.eventStatus='MARK_TO_GRADE_TRANFORMED' and result.calculationDone=false) or ((plan.markingMethod<>'INDIVIDUAL' or plan.markingMethod is null) and (result.examResultStatus is not null or result.whetherExamAttended = false or plan.remarkOnlyAssessment = true or type.remarkOnlyAssessment=true or subType.remarkOnlyAssessment=true or method.remarkOnlyAssessment=true) and result.calculationDone = false))
group by admission.id, sections.id, period.id, cv.id, plan.id

union all

select 
null as id,
result.id as examResultEventId,
cv.id as courseVariantId,
sections.id as sectionId,
admission.id as admissionId,
admission.code as admissionCode,
users.code as studentCode,
plan.id as evaluationPlanId,
plan.evaluationPlanNumber as evaluationPlanNumber,
plan.evaluationPlanType as evaluationPlanType,
plan.markingMethod as markingMethod,
plan.isLongDistance as isLongDistanceForTable,
sections.sectionCode as sectionName,
period.id as periodId,
period.printName as periodName,
batches.id as batchId,
batches.printName as batchName,
programs.id as programId,
programs.programNameToBePrint as programName,
cv.courseVariantCode as courseVariantCode,
courses.id as courseId,
courses.courseCode as courseCode,
courses.nameToBePrinted as courseName,
param.courseCredits as courseCredits,
plan.roundingMode as roundingMode,
plan.roundingCount as roundingCount,
plan.whetherDroolApplicable as whetherDroolApplicable,
plan.resultCalculationStatus as resultCalculationStatus,
plan.whetherConsiderAbsentAsFail as whetherConsiderAbsentAsFail,
plan.considerOpenForMarkEntry as considerOpenForMarkEntry,
drool_rules.id as droolRuleId,
drool_rules.droolCode as droolCode,
al.terminology as terminology,
type.id as ruleAppliedForLevelOneId,
subType.id as ruleAppliedForLevelTwoId,
method.id as ruleAppliedForLevelThreeId,
event.id as ruleAppliedForLevelFourId,
event.weightage as weightage,
event.whetherATKTRequired as whetherATKTRequired,
event.whetherDetailSeqEquivalent as whetherDetailSeqEquivalent,
param.courseGradeType as paramGradeType,
result.whetherDetention as whetherDetention,
result.calculationPriority,
null as markEntryDate
from exam_result_event_students as result
left join course_variants as cv on result.courseVariantId=cv.id
left join evaluation_type_course as type_course on cv.id=type_course.courseVariantId and type_course.periodId=result.periodId and type_course.sectionId=result.sectionId
left join course_variant_event_mapping as event_mapping on type_course.id=event_mapping.evaluationTypeCourseId and event_mapping.eventId=result.eventId
join eval_seq_detail as event on result.eventId=event.id
left join courses on cv.courseId=courses.id
join sections on result.sectionId=sections.id
join prog_batch_period_config as period on result.periodId=period.id
join admission on result.admissionId=admission.id
join users on admission.studentId=users.id
join batches on period.programBatchId=batches.id
join programs on batches.programId=programs.id
join academy_location as al on programs.academyLocationId=al.id
left join program_batch_course_param as param on type_course.programBatchCourseParamId=param.id
join evaluation_sequence as method on event.evalSequenceId=method.id
join evaluation_plan_level_two as subType on method.evalPlanLevelTwoId=subType.id
join evaluation_plan_level_one as type on subType.evalPlanLevelOneId=type.id
join evaluation_plan as plan on type.evaluationPlanId=plan.id
left join drool_rules on plan.droolId=drool_rules.id
left join evaluation_type_program as typeProgram on typeProgram.evaluationPlanId=plan.id and typeProgram.programBatchPeriodConfigId=result.periodId and typeProgram.sectionId=result.sectionId
left join course_variant_event_mapping as other_event_mapping on other_event_mapping.evaluationTypeProgramId=typeProgram.id and other_event_mapping.eventId=event.id
where (cv.id is null or cv.whetherExamCompleted = false)
and (plan.status = 'PENDING' or plan.status = 'MARK_TO_GRADE_TRANFORMED') 
and (event_mapping.eventStatus='CONDUCTED' or other_event_mapping.eventStatus='CONDUCTED')
and result.calculationDone = false
and result.whetherDetention = true
group by admission.id, sections.id, period.id, cv.id, plan.id
order by calculationPriority asc, markEntryDate asc
limit recordLimit;
END$$

DELIMITER ;

DELIMITER $$
