DELIMITER $$
DROP PROCEDURE IF EXISTS V20241225110426__Create_xeroCreditNoteMapping $$
CREATE PROCEDURE V20241225110426__Create_xeroCreditNoteMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='xero_credit_note_mapping')) THEN 
CREATE TABLE xero_credit_note_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
    xeroCreditNoteId varchar(255) NOT NULL,
	invoiceNumber varchar(255) NOT NULL,
    academiaBillHeaderId bigint NOT NULL,
    xeroCreditNoteType varchar(255) NOT NULL,
	lineAmount double default NULL,
    xeroUserId varchar(255) NOT NULL,
    academiaUserId bigint NOT NULL,
	academyLocationId bigint NOT NULL,
	error TEXT default NULL,
    xeroStatus varchar(255) default null,
    createdDate DATE NULL,
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_xero_credit_note_mapping_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_xero_credit_note_mapping_academiaBillHeaderId_idx (academiaBillHeaderId),
  KEY fk_xero_credit_note_mapping_academiaUserId_idx (academiaUserId),
  KEY fk_xero_credit_note_mapping_academyLocationId_idx (academyLocationId),
  CONSTRAINT fk_xero_credit_note_mapping_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_xero_credit_note_mapping_academiaBillHeaderId FOREIGN KEY (academiaBillHeaderId) REFERENCES bill_header (id),
  CONSTRAINT fk_xero_credit_note_mapping_academiaUserId FOREIGN KEY (academiaUserId) REFERENCES users (id),
  CONSTRAINT fk_xero_credit_note_mapping_academyLocationId FOREIGN KEY (academyLocationId) REFERENCES academy_location (id)
  ) ENGINE=InnoDB;
END IF; 

END $$
CALL V20241225110426__Create_xeroCreditNoteMapping () $$ 
DROP PROCEDURE IF EXISTS V20241225110426__Create_xeroCreditNoteMapping $$ 
DELIMITER ;