DELIMITER $$
DROP PROCEDURE IF EXISTS V20241226110633__Create_CreateCourseLecturerCostDtls $$
CREATE PROCEDURE V20241226110633__Create_CreateCourseLecturerCostDtls()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_lecturer_cost_dtls')) THEN

CREATE TABLE `course_lecturer_cost_dtls` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`academicTermId` BIGINT(20) NOT NULL,
	`courseVariantId` BIGINT(20) NOT NULL,
	`facultyId` BIGINT(20) NOT NULL,
	`programBatchCourseParamId` BIGINT(20) NOT NULL,
	`fromDate` TIMESTAMP NOT NULL,
  	`tillDate` TIMESTAMP NOT NULL,
	`currencyId` BIGINT(20) NOT NULL,
    `cost` DOUBLE NOT NULL,
    `comments` VARCHAR(255) NOT NULL,
    `isMapped` BOOLEAN DEFAULT 1,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_course_lecturer_cost_dtls_academic_term_Id_idx` (`academicTermId` ASC),
  INDEX `fk_course_lecturer_cost_dtls_course_variant_Id_idx` (`courseVariantId` ASC),
	INDEX `fk_course_lecturer_cost_dtls_faculty_Id_idx` (`facultyId` ASC),
    INDEX `fk_course_lecturer_cost_dtls_programBatchCourseParam_Id_idx` (`programBatchCourseParamId` ASC),
    INDEX `fk_course_lecturer_cost_dtls_currency_Id_idx` (`currencyId` ASC),
  INDEX `fk_course_lecturer_cost_dtls_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_course_lecturer_cost_dtls_academic_term_id`
    FOREIGN KEY (`academicTermId`)
    REFERENCES `academic_term` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_lecturer_cost_dtls_course_variant_id`
    FOREIGN KEY (`courseVariantId`)
    REFERENCES `course_variants` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_course_lecturer_cost_dtls_faculty_id`
    FOREIGN KEY (`facultyId`)
    REFERENCES `staffs` (`userId`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_course_lecturer_cost_dtls_programBatchCourseParam_id`
    FOREIGN KEY (`programBatchCourseParamId`)
    REFERENCES `program_batch_course_param` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_course_lecturer_cost_dtls_currency_id`
    FOREIGN KEY (`currencyId`)
    REFERENCES `currency` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_lecturer_cost_dtls_lastUpdateBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF;

END $$
CALL V20241226110633__Create_CreateCourseLecturerCostDtls () $$ 
DROP PROCEDURE IF EXISTS V20241226110633__Create_CreateCourseLecturerCostDtls $$ 
DELIMITER ;