DELIMITER $$
DROP PROCEDURE IF EXISTS V20241231135901__Update_EventReminderOnDateRecipients $$
CREATE PROCEDURE V20241231135901__Update_EventReminderOnDateRecipients()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="EVENT_REMINDER_ON_DATE_RECIPIENTS") THEN 

SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="EVENT_REMINDER_ON_DATE_RECIPIENTS");

update sql_dtprovider set sqlQuery="SELECT 
    rbu.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    rb.eventName AS EVENT_NAME,
    rb.venue AS VENUE,
    rb.eventDesc AS EVENT_DESC,
    DATE_FORMAT(rb.eventDate,'%d-%m-%Y') as EVENT_DATE, 
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
 ml.code AS LANGUAGE_KEY
FROM
    resource_bookings rb
        JOIN
    resource_booking_users rbu ON rbu.resourceBookingId = rb.id
        JOIN
    staffs s ON s.userId = rbu.userId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
LEFT JOIN
    multi_language ml ON ml.id = p.correspondence_language
WHERE
    rbu.id in (namedParams)
GROUP BY rbu.id
UNION
SELECT 
    rbu.id AS ID,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    rb.eventName AS EVENT_NAME,
    rb.venue AS VENUE,
    rb.eventDesc AS EVENT_DESC,
    DATE_FORMAT(rb.eventDate,'%d-%m-%Y') as EVENT_DATE, 
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    resource_bookings rb
        JOIN
    resource_booking_users rbu ON rbu.resourceBookingId = rb.id
        JOIN
    students st ON st.userId = rbu.studentId
        JOIN
    persons p ON p.id = st.personId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = st.userId
        LEFT JOIN
    multi_language ml on ml.id=p.correspondence_language
WHERE
    rbu.id in (namedParams)
GROUP BY rbu.id"
   where dataProviderId=@dtProviderId;  

END IF; 
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20241231135901__Update_EventReminderOnDateRecipients () $$
DROP PROCEDURE IF EXISTS V20241231135901__Update_EventReminderOnDateRecipients $$
DELIMITER ;