DELIMITER $$
DROP PROCEDURE IF EXISTS V20250109125644__Update_Admission_Info_data_provider $$
CREATE PROCEDURE V20250109125644__Update_Admission_Info_data_provider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item d WHERE d.dataSourceCode='ADMISSION_INFO')) THEN 
SET @dydtDataLineItemId=(select id from dydt_data_line_item d WHERE d.dataSourceCode='ADMISSION_INFO' and publishAsParametersDef is null limit 1);
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT p.firstName AS student_firstname ,p.lastName AS student_lastname ,p.middleName 
    AS student_middlename,p.gender AS student_gender,p.printName  AS student_printname,
    sln.salutationName AS applicant_salutation,DATE_FORMAT(p.birthDate, \'%d-%m-%Y\') AS birth_date,cc.itemCode as 
    student_caste,r.itemCode as student_religion,cou.countryName as student_country  , user.code as student_code 
    FROM students s LEFT JOIN  persons p ON s.personId = p.id LEFT JOIN salutations sln ON 
    p.salutationId = sln.id LEFT JOIN caste_categories cc ON p.castCategoryId=cc.id 
    LEFT JOIN religions r ON p.religionId=r.id LEFT JOIN country cou ON p.countryId=cou.id
    LEFT JOIN users user ON s.userId=user.id'
    WHERE id =@dydtDataLineItemId;
END IF; 

IF EXISTS ((select * from dydt_data_line_item d WHERE d.dataSourceCode='ADMISSION_INFO')) THEN 
SET @dydtDataLineItem=(select id from dydt_data_line_item d WHERE d.dataSourceCode='ADMISSION_INFO' and publishAsParametersDef is not null limit 1);
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
    p.programCode AS program_code,
    p.programName AS program_name,
    p.programNameToBePrint AS program_print_name,
    pd.shortCode AS primary_dept_code,
    pd.deptName AS primary_dept_name,
    psd.shortCode AS secondary_dept_code,
    psd.deptName AS secondary_dept_name,
    b.batchName AS batch_name,
    b.startDate AS batch_start_date,
    b.tillDate AS batch_tilldate,
    ay.itemValue AS academic_year,
    a.code AS admission_code,
    a.studentId AS student_id,
    pbpc.printName AS last_period_name,
    DATE_FORMAT(pbpc.programPeriodStart, \'%d-%m-%Y\') AS period_start_date,
    DATE_FORMAT(pbpc.programPeriodEnd, \'%d-%m-%Y\') AS period_end_date,
    epr.sgpa AS SGPA_of_last_period,
    ad.pincode AS post_number,
    u.printName AS program_advisor,
    des.itemValue AS program_advisor_designation,
    (SELECT 
            prog_batch_period_config.printName
        FROM
            evaluation_period_rank
                LEFT JOIN
            prog_batch_period_config ON prog_batch_period_config.id = evaluation_period_rank.periodId
        WHERE
            evaluation_period_rank.admissionId = a.id
        ORDER BY evaluation_period_rank.id DESC
        LIMIT 1 OFFSET 1) AS second_last_period
FROM
    admission a
        LEFT JOIN
    programs p ON a.programId = p.id
        LEFT JOIN
    prog_batch_seat_config pbsc ON a.programBatchSeatConfigId = pbsc.id
        LEFT JOIN
    batches b ON b.id = pbsc.programBatchId
        LEFT JOIN
    intake_year ay ON ay.id = b.intakeYearId
        LEFT JOIN
    department pd ON pd.id = p.programDepartmentId
        LEFT JOIN
    department psd ON psd.id = p.subDepartmentId
        LEFT JOIN
    prog_batch_period_config pbpc ON pbpc.programBatchId = pbsc.programBatchId
        LEFT JOIN
    evaluation_period_rank epr ON epr.periodId = pbpc.id
        AND epr.admissionId = a.id
        LEFT JOIN
    students s ON a.studentId = s.userId
        LEFT JOIN
    persons per ON s.personId = per.id
        LEFT JOIN
    person_addresses pad ON pad.personId = per.id
        AND pad.addresstypeId = 7
        LEFT JOIN
    address ad ON ad.id = pad.addressId
        LEFT JOIN
    users u ON p.approver = u.id
        LEFT JOIN
    staffs staffs ON u.id = staffs.userId
        LEFT JOIN
    designations des ON staffs.designationId = des.id'
    WHERE id =@dydtDataLineItem;
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250109125644__Update_Admission_Info_data_provider () $$
DROP PROCEDURE IF EXISTS V20250109125644__Update_Admission_Info_data_provider $$
DELIMITER ;