DELIMITER $$
DROP PROCEDURE IF EXISTS V20250122230318__Update_OUT_BILL_MOTHER_REM_ON_DAY_S1_RCPNT $$
CREATE PROCEDURE V20250122230318__Update_OUT_BILL_MOTHER_REM_ON_DAY_S1_RCPNT()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (SELECT * FROM dtprovider where dataProviderName = "OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT") THEN 
SET @dataProviderId = (SELECT id FROM dtprovider where dataProviderName = "OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT");

UPDATE sql_dtprovider 
SET sqlQuery = "SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE  bh.raiseBillCategory!='BILL_PAYABLE' and 
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id "
where dataProviderId = @dataProviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250122230318__Update_OUT_BILL_MOTHER_REM_ON_DAY_S1_RCPNT () $$
DROP PROCEDURE IF EXISTS V20250122230318__Update_OUT_BILL_MOTHER_REM_ON_DAY_S1_RCPNT $$
DELIMITER ;