DELIMITER $$
DROP PROCEDURE IF EXISTS V20250317140855__Create_UWC_Mainstream_Transcript_Report $$
CREATE PROCEDURE V20250317140855__Create_UWC_Mainstream_Transcript_Report()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet'); 

IF NOT EXISTS (select * from report_template where templateCode='UWC_MAINSTREAM_TRANSCRIPT') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'UWC_MAINSTREAM_TRANSCRIPT', 'UWC Mainstream Transcript', 'UWC_MAINSTREAM_TRANSCRIPT.png', 'CommonReport_UWC_MAINSTREAM_TRANSCRIPT.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'UWC_MAINSTREAM_TRANSCRIPT.jasper', 'AcademiaLogo.png');
END IF; 

set @tempKeySurname = (select max(id) from report_template 
where templateCode ='UWC_MAINSTREAM_TRANSCRIPT' and templateName='UWC Mainstream Transcript');


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ACADEMIC_TRANSCRIPT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ACADEMIC_TRANSCRIPT', 'ACADEMIC TRANSCRIPT', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ACADEMIC_ADMINISTRATION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ACADEMIC_ADMINISTRATION', 'ACADEMIC ADMINISTRATION – REGISTRAR’S DIVISION', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_THE_UNIVERSITY1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_THE_UNIVERSITY1', 'The University of the Western Cape is a Public Higher Education institution established and regulated by the Higher Education Act, No. 101 of 1997 (Republic of South Africa), with the language of instruction being English.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_THE_UNIVERSITY2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_THE_UNIVERSITY2', 'The University is duly accredited by the Council on Higher Education and its degrees and diplomas are registered on the National Qualifications Framework in terms of the South African Qualifications Authority Act, No. 58 of 1995.', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CERTIFY1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CERTIFY1', 'This is to certify that the student', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CERTIFY2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CERTIFY2', 'was/is registered at this University for the qualification/s listed below. The programme of study, assessment results and credits obtained are detailed and an overall summary is provided.', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_UWC_STUDENT_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_UWC_STUDENT_NAME', 'UWC Student Number', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_IDENTITY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_IDENTITY', 'Identity Number/Passport Number', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_BIRTH_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_BIRTH_DATE', 'Date of Birth', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_REG_YEAR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_REG_YEAR', 'Current/Last Registration Year', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_MEDIUM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_MEDIUM1', 'MEDIUM/LANGUAGE OF INSTRUCTION', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ENGLISH')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ENGLISH', 'ENGLISH', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_MEDIUM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_MEDIUM2', '(all learning, teaching and assessments are conducted in English)', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_CONDUCT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_CONDUCT1', 'Student Conduct: SATISFACTORY', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_CONDUCT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_CONDUCT2', '(behaviour during the period of study, related to student discipline). Student qualifies for a certificate of good conduct for the duration of the studies. Records reflect no negative report on conduct.', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_YOURS_SINCERELY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_YOURS_SINCERELY', 'Yours sincerely', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_REGISTRAR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_REGISTRAR', 'REGISTRAR', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ACADEMIC_ADMINISTRATION1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ACADEMIC_ADMINISTRATION1', 'ACADEMIC ADMINISTRATION', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_THIS_DOCUMENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_THIS_DOCUMENT', 'This document contains a qualified electronic signature and date stamp. To verify this document contact the Graduation Office of the University of the Western Cape at helpdesk@uwc.ac.za.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_NOTE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_NOTE', 'Please note that the Registrar’s signature and University stamp are electronically embedded.', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_ACADEMIC_PROGRAMME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_ACADEMIC_PROGRAMME', 'ACADEMIC PROGRAMME RECORD', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PROGRAMME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PROGRAMME', 'Programme', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_NAME', 'Qualification Name', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPE', 'Qualification Type', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_STUDY_TYPE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_STUDY_TYPE', 'Study Type', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_SAQA')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_SAQA', 'SAQA Registration', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_MODULE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_MODULE', 'Module', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CREDITS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CREDITS', 'Credits', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_NQF')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_NQF', 'NQF', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_RESULT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_RESULT', 'Result%', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_REMARK')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_REMARK', 'Remark', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_YEAR_GPA_WEIGHTED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_YEAR_GPA_WEIGHTED', 'Year GPA or Weighted Average', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME', 'Outcome', '1', NOW());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATE_ISSUED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATE_ISSUED', 'Date Issued', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_NAME1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_NAME1', 'Student Number', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PARTICIPANT_NUMBER1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PARTICIPANT_NUMBER1', 'Student Name', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODE_DESCRIPTIONS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODE_DESCRIPTIONS', 'CODE DESCRIPTIONS', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES', 'CODES', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES1', 'NO YEARMARK: Absent from the examination - No Result', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES2', 'Absent from the examination but with permission on medical grounds to write a supplementary examination.', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES3')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES3', 'Absent from the examination but with special permission to write supplementary examination.', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES4')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES4', 'Application to write a supplementary examination on special or medical grounds has not been granted.', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES6')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES6', 'Supplementary Examination granted on academic grounds.', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES7')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES7', 'You failed to obtain the required sub minimum and have to repeat the course.', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES8')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES8', 'Has been unable to complete Term 2. Will be allowed to redo the module (Term 2 components only) during the catch-up period.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES9')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES9', 'Has obtained a minimum of 50% for the module but has assessment tasks outstanding. Please consult your Department for outstanding Term 2 tasks.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES10')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES10', 'Failed to meet the 50% requirement to pass. Student will be allowed to redo the module (Term 2 components only) during the catch-up period.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_CODES11')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_CODES11', 'Does not qualify for examination.', '1', NOW());
END IF;





IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_SYMBOLS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_SYMBOLS', 'SYMBOLS', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_SYMBOLS_DESCRIPTION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_SYMBOLS_DESCRIPTION', 'A: 75-100 % (Pass), B: 70-74 % (Pass), C: 60-69 % (Pass), D: 50-59 % (Pass), E: 45-49 % (Fail), F: 40-44 % (Fail), G: 0-39 % (Fail)', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DEFINITIONS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DEFINITIONS', 'DEFINITIONS', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_GPA_WEIGHTED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_GPA_WEIGHTED', 'GPA/WEIGHTED AVERAGE', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_GRADE_POINTS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_GRADE_POINTS', 'Grade Point Average (GPA)/Weighted Average is a number (%) that represents the average of all the student s grades during a study period (passed, failed or repeated). It is weighted by the number of credits allocated to all the modules the student was enrolled for (passed, failed or repeated) in a particular programme of study. GPAs/Weighted Averages are reflected in this academic record per year of study and for the overall programme.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_UWC_WEIGHTED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_UWC_WEIGHTED', 'UWC Weighted Avg/GPA (%)', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_GPA_SCORE_POINT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_GPA_SCORE_POINT', 'GPA Point Score (international equivalent)', '1', NOW());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_SAQA_REGIS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_SAQA_REGIS', 'SAQA Registration - South African Qualifications Authority identification number,', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_SAQA_REGIS1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_SAQA_REGIS1', 'the number against which the degree/qualification is registered.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_NQF_NATIONAL')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_NQF_NATIONAL', 'NQF - National Qualifications Framework', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_NQF_NATIONAL1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_NQF_NATIONAL1', 'is the system that records the credits assigned to each level of learning achievement in a formal way to ensure that the skills and knowledge that have been learnt are recognised throughout the Republic of South Africa.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION', 'Qualification', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DEFINITION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DEFINITION', 'Definition', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_MODULE_LEVEL')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_MODULE_LEVEL', 'Module level', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_HIGHER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_HIGHER', 'Higher Certificate (the entry level of an undergraduate diploma or bachelor’s degree)', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_NATIONAL')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_NATIONAL', 'National Diploma and Advanced Certificate (the intermediate level of an undergraduate diploma or bachelor’s degree)', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_BACHELOR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_BACHELOR', 'Bachelor’s Degree and Advanced Diploma (the exit level of a 3-year bachelor’s degree or advanced diploma)', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PROFESSION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PROFESSION', 'Professional Bachelor’s Degree, Honours Degree and Postgraduate Diploma (the exit level of a professional 4- or 6-year bachelor’s degree, postgraduate diploma or honours degree)', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_MASTER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_MASTER', 'Master’s Degree', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DOCTOR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DOCTOR', 'Doctoral Degree', '1', NOW());
END IF;





IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES', 'Qualification Types', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES1', 'Undergraduate Diploma or Certificate', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES2', 'A diploma or certificate, which does not have a bachelor''s degree as prerequisite for admission to the programme.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES3')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES3', 'General Academic First Bachelor''s Degree', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES4')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES4', 'A first bachelor''s degree with a duration of three years. A first bachelor''s degree is one for which a matriculation exemption certificate is a minimum prerequisite for admission to the programme.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES5')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES5', 'Professional First Bachelor''s Degree', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES6')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES6', 'A first bachelor''s degree with a duration of four or more years.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES7')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES7', 'Postgraduate Diploma or Certificate', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES8')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES8', 'A diploma or certificate with a bachelor''s degree as prerequisite for admission to the programme.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES9')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES9', 'Postgraduate Bachelor''s Degree', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES10')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES10', 'A bachelor’s degree with a ·first bachelor''s degree as prerequisite for admission to the programme.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES11')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES11', 'Honours Degree', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES12')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES12', 'A postgraduate degree that follows on from the completion of a bachelor''s degree', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES13')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES13', 'Master’s Degree', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES14')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES14', 'A postgraduate degree that follows on from the completion of a relevant Honours Degree or Professional Bachelor''s Degree or a Postgraduate Diploma.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES15')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES15', 'Doctoral Degree', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_QUALIFICATION_TYPES16')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_QUALIFICATION_TYPES16', 'Is the highest qualification type awarded within the qualification Framework', '1', NOW());
END IF;





IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS', 'Dates and Keys', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS1', 'Start date', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS2', 'Date upon which the student first registered for the programme.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS3')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS3', 'Completion date', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS4')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS4', 'Date upon which the student had met all requirements for the completion of the programme.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS5')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS5', 'Graduation date', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS6')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS6', 'Date upon which the qualification/degree was officially conferred at a graduation ceremony.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS7')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS7', 'Certificate key', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_DATES_KEYS8')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_DATES_KEYS8', 'Code or security key that appears on the issued certificate. Unique for each certificate issued.', '1', NOW());
END IF;





IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOMES')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOMES', 'Outcome', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME1', 'Completed', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME2', 'Degree/qualification has been completed. All requirements for completion have been met.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME3')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME3', 'Current academic year', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME4')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME4', 'Current year of registration.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME5')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME5', 'DC Pending - Results withheld', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME6')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME6', 'You have a Disciplinary Case (DC) pending and will not be able to register until an outcome has been received of your pending DC Case.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME7')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME7', 'Examinations deferred', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME8')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME8', 'Your examination/s has been deferred.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME9')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME9', 'Failed', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME10')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME10', 'You have not obtained enough credits to promote to the next level of studies but may continue to register for the upcoming year.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME11')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME11', 'Leave of absence granted', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME12')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME12', 'You have been approved for a leave of absence.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME13')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME13', 'May not proceed: no research topic approved', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME14')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME14', 'You may not register as there is no research topic that has been approved. Please contact your Faculty in this regard.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME15')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME15', 'May not proceed: submit completion plan', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME16')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME16', 'You may not register as no completion plan has been submitted. Please contact your faculty in this regard.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME17')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME17', 'May proceed with studies', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME18')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME18', 'You may proceed with your studies.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME19')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME19', 'May proceed with studies: extension granted', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME20')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME20', 'Your study extension has been approved and you may continue to register for the following year.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME21')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME21', 'Not promoted: non-degree purpose/CE course', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME22')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME22', 'You have not obtained enough credits to promote /complete a non-degree course or CE Programme to the next level of studies but can continue to register.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME23')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME23', 'Promoted', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME24')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME24', 'You have obtained enough credits to promote to the next year level.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME25')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME25', 'Re-admission not allowed', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME26')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME26', 'You have been academically excluded and need to apply for re-admission to the University.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME27')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME27', 'Refused academically/can register', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME28')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME28', 'You have been refused academically but have now been cleared and you can continue with your studies.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME29')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME29', 'Results not available', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME30')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME30', 'Your results are not currently available. Please contact your Faculty in this regard.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME31')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME31', 'DC Pending - Results withheld', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME32')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME32', 'You have a Disciplinary Case (DC) pending and will not be able to register
until an outcome has been received of your pending DC.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME33')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME33', 'Suspended', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_OUTCOME34')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_OUTCOME34', 'You have been suspended from the University.', '1', NOW());
END IF;




IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PLEASE_NOTE1')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PLEASE_NOTE1', 'Please note that in certain instances results are provisional and are subject to change. Although the University endeavours at all times to publish results accurately, errors may occur.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PLEASE_NOTE2')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PLEASE_NOTE2', 'An error does not give the candidate the right to a pass mark or the award of a certificate, diploma or degree.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempKeySurname and keyValue='TRANS_PLEASE_NOTE3')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempKeySurname, 'TRANS_PLEASE_NOTE3', 'Any alteration to this document in any manner or form is a contravention of the University’s rules, regulations, policies, procedures and standing orders and may constitute fraud.', '1', NOW());
END IF;


END $$
CALL V20250317140855__Create_UWC_Mainstream_Transcript_Report () $$ 
DROP PROCEDURE IF EXISTS V20250317140855__Create_UWC_Mainstream_Transcript_Report $$ 
DELIMITER ;