DELIMITER $$
DROP PROCEDURE IF EXISTS V20250421124015__Update_StandardMasterSmtpOauthConfigUpdate $$
CREATE PROCEDURE V20250421124015__Update_StandardMasterSmtpOauthConfigUpdate()
BEGIN
SET SQL_SAFE_UPDATES=0;
set @standardMasterId=(select id from standard_master where tableName= 'smtp_oauth_two_configuration' and masterName='SMTP_OAUTH_TWO_CONFIGURATION');
set @standardMasterItemsclientId=(select id from standard_master_items where standardMasterId=@standardMasterId and dbFieldName='clientId');
set @standardMasterItemsclientSecretId=(select id from standard_master_items where standardMasterId=@standardMasterId and dbFieldName='clientSecret');
set @standardMasterItemstenantId=(select id from standard_master_items where standardMasterId=@standardMasterId and dbFieldName='tenantId');

IF EXISTS ((select * from standard_master_items where id = @standardMasterItemsclientId AND dbFieldName = 'clientId')) THEN 
UPDATE `standard_master_items` SET fieldType='TextArea', whetherReadOnly=true WHERE id = @standardMasterItemsclientId;
END IF;

IF EXISTS ((select * from standard_master_items where id = @standardMasterItemsclientSecretId AND dbFieldName = 'clientSecret')) THEN 
UPDATE `standard_master_items` SET fieldType='TextArea', whetherReadOnly=true WHERE id = @standardMasterItemsclientSecretId;
END IF;

IF EXISTS ((select * from standard_master_items where id = @standardMasterItemstenantId AND dbFieldName = 'tenantId')) THEN 
UPDATE `standard_master_items` SET fieldType='TextArea', whetherReadOnly=true WHERE id = @standardMasterItemstenantId;
END IF;  

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250421124015__Update_StandardMasterSmtpOauthConfigUpdate () $$
DROP PROCEDURE IF EXISTS V20250421124015__Update_StandardMasterSmtpOauthConfigUpdate $$
DELIMITER ;