DELIMITER $$
DROP PROCEDURE IF EXISTS V20250429150634__Update_ATTESTATION_TABLE_ONE $$
CREATE PROCEDURE V20250429150634__Update_ATTESTATION_TABLE_ONE()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select id from dydt_data_line_item where dataSourceCode="ATTESTATION_TABLE_ONE")) THEN 
SET @dydtdatalinitemId=(select id from dydt_data_line_item where dataSourceCode="ATTESTATION_TABLE_ONE");

UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT 
        pbpc.printName AS PERIOD_NAME,
        pbpc.attestationLineOne AS ATTESTATION,
        CONCAT(CASE
                    WHEN
                        (SELECT 
                                c.ectsCredits
                            FROM
                                program_courses_period pcpcourseCredits
                                    JOIN
                                prog_batch_period_config pbpccourseCredits ON pbpccourseCredits.id = pcpcourseCredits.periodId
                                    JOIN
                                program_courses pccourseCredits ON pccourseCredits.id = pcpcourseCredits.programCourseId
                                    JOIN
                                courses ccourseCredits ON ccourseCredits.id = pccourseCredits.courseId
                            WHERE
                                pcpcourseCredits.periodId = pbpc.id
                                    AND ccourseCredits.ectsCredits IS NOT NULL
                                    AND ccourseCredits.ectsCredits > 0
                            LIMIT 1) > 0
                    THEN
                        "Yes - ECTS&nbsp;&nbsp;&nbsp;"
                    ELSE "No - ECTS&nbsp;&nbsp;&nbsp;"
                END,
                CASE
                    WHEN
                        (SELECT 
                                c.courseCredits
                            FROM
                                program_courses_period pcpcourseCredits
                                    JOIN
                                prog_batch_period_config pbpccourseCredits ON pbpccourseCredits.id = pcpcourseCredits.periodId
                                    JOIN
                                program_courses pccourseCredits ON pccourseCredits.id = pcpcourseCredits.programCourseId
                                    JOIN
                                courses ccourseCredits ON ccourseCredits.id = pccourseCredits.courseId
                            WHERE
                                pcpcourseCredits.periodId = pbpc.id
                                    AND ccourseCredits.courseCredits IS NOT NULL
                                    AND ccourseCredits.courseCredits > 0
                            LIMIT 1) > 0
                    THEN
                        "Yes - US "
                    ELSE "No - US"
                END) AS CREDIT
    FROM
        program_courses_period pcp
            JOIN
        prog_batch_period_config pbpc ON pbpc.id = pcp.periodId
            JOIN
        program_courses pc ON pc.id = pcp.programCourseId
            JOIN
        courses c ON c.id = pc.courseId
            JOIN
        student_journey sj ON sj.periodId = pcp.periodId'
WHERE
    (`id` = @dydtdatalinitemId);

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250429150634__Update_ATTESTATION_TABLE_ONE () $$
DROP PROCEDURE IF EXISTS V20250429150634__Update_ATTESTATION_TABLE_ONE $$
DELIMITER ;