DELIMITER $$
DROP PROCEDURE IF EXISTS V20250520170453__Alter_AddColInStudentTranferRequest $$
CREATE PROCEDURE V20250520170453__Alter_AddColInStudentTranferRequest()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'student_transfer_request_multiple_reason' 
      AND COLUMN_NAME = 'studentTransferReasonCsmId'
) THEN
    ALTER TABLE student_transfer_request_multiple_reason
    ADD COLUMN studentTransferReasonCsmId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.referential_constraints 
    WHERE constraint_schema = DATABASE() 
      AND TABLE_NAME = 'student_transfer_request_multiple_reason' 
      AND CONSTRAINT_NAME = 'fk_reason_for_student_transfer'
) THEN
    ALTER TABLE student_transfer_request_multiple_reason
    ADD CONSTRAINT fk_reason_for_student_transfer FOREIGN KEY (studentTransferReasonCsmId) REFERENCES reason_for_student_transfer(id);
END IF; 

INSERT IGNORE INTO reason_for_student_transfer (id, itemCode, itemValue, studentTransferActive, lastUpdatedBy,lastUpdate)
select dd.id,name,value,b'1',1,now() from drop_down  dd
join student_transfer_request_multiple_reason AS strmr on strmr.studentTransferReasonId=dd.id group by dd.id;

SET SQL_SAFE_UPDATES=0;
UPDATE student_transfer_request_multiple_reason AS strmr
JOIN student_transfer_request_multiple_reason AS strmrself
ON strmrself.studentTransferRequestDetailId = strmr.studentTransferRequestDetailId
SET strmr.studentTransferReasonCsmId = strmrself.studentTransferReasonId;
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20250520170453__Alter_AddColInStudentTranferRequest() $$
DROP PROCEDURE IF EXISTS V20250520170453__Alter_AddColInStudentTranferRequest $$
DELIMITER ;