DELIMITER $$

DROP PROCEDURE IF EXISTS V20250528183958__Alter_ADDServiceRequestSetupDatesIdColumn $$

CREATE PROCEDURE V20250528183958__Alter_ADDServiceRequestSetupDatesIdColumn()
BEGIN
    IF NOT EXISTS (
        SELECT * 
        FROM information_schema.columns 
        WHERE table_schema = DATABASE() 
          AND table_name = 'request_type_program_period_mapping' 
          AND column_name = 'serviceRequestSetupDatesId'
    ) THEN
        ALTER TABLE request_type_program_period_mapping
            ADD COLUMN serviceRequestSetupDatesId BIGINT DEFAULT NULL;

        IF NOT EXISTS (
            SELECT index_name 
            FROM information_schema.statistics 
            WHERE table_schema = DATABASE() 
              AND table_name = 'request_type_program_period_mapping' 
              AND index_name = 'rtppm_serviceRequestSetupDatesId_idx'
        ) THEN
            ALTER TABLE request_type_program_period_mapping 
                ADD INDEX rtppm_serviceRequestSetupDatesId_idx (serviceRequestSetupDatesId);
        END IF;

        IF NOT EXISTS (
            SELECT * 
            FROM information_schema.referential_constraints 
            WHERE constraint_schema = DATABASE() 
              AND constraint_name = 'fk_rtp_serviceRequestSetupDatesId' 
              AND table_name = 'request_type_program_period_mapping'
        ) THEN
            ALTER TABLE request_type_program_period_mapping 
                ADD CONSTRAINT fk_rtp_serviceRequestSetupDatesId
                FOREIGN KEY (serviceRequestSetupDatesId)
                REFERENCES service_request_setup_dates (id)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT;
        END IF;

    END IF;
END $$

CALL V20250528183958__Alter_ADDServiceRequestSetupDatesIdColumn() $$

DROP PROCEDURE IF EXISTS V20250528183958__Alter_ADDServiceRequestSetupDatesIdColumn $$

DELIMITER ;
