DELIMITER $$
DROP PROCEDURE IF EXISTS getHESAVenueDetailsData $$
CREATE PROCEDURE getHESAVenueDetailsData(IN programId BIGINT)
BEGIN

SELECT 
    al.displayNameOL AS 'OWNVENUEID',
    ads.pincode AS 'POSTCODE',
    al.academyCode AS 'VENUEID',
    al.displayName AS 'VENUENAME',
    vu.itemCode AS 'VENUEUKPRN'
FROM
    programs p
        LEFT JOIN
    academy_location al ON p.academyLocationId = al.id
        LEFT JOIN
    academy_location_addresses ala ON al.id = ala.academyLocationId
        LEFT JOIN
    address ads ON ala.addressId = ads.id
        LEFT JOIN
    venue_ukprn vu ON al.venueUkprnId = vu.id
WHERE
    p.id IN (programId);

END $$ 
DELIMITER ;