DELIMITER $$
DROP PROCEDURE IF EXISTS getModuleRegistrationDetails $$
CREATE PROCEDURE getModuleRegistrationDetails(IN transdate DATE)
BEGIN
select "RDAP" as rdap, "RDBL" as rdbl, "NIC" as nic, "LEARNER ID" as learner_id, "FIRST NAME" as first_name, "LAST NAME" as last_name, "MAIDEN NAME" as maiden_name, "INTAKE" as intake, "INTAKE FORMATTED" as intake_formatted, "LOGIN EMAIL" as login_email, "CONTACT EMAIL" as contact_email, "PROGRAMME NAME" as programme, "PROGRAMME CODE FOR ACCOUTING" as programCodeForAccounting, "MODULE_ID 1ψMODULE_ID 2ψMODULE_ID 3ψMODULE_ID 4ψMODULE_ID 5ψMODULE_ID 6" as module_id, "MODULE 1ψMODULE 2ψMODULE 3ψMODULE 4ψMODULE 5ψMODULE 6" as module, "MODULE CODE 1ψMODULE CODE 2ψMODULE CODE 3ψMODULE CODE 4ψMODULE CODE 5ψMODULE CODE 6" as module_code, "COMMON MODULE CODE 1ψCOMMON MODULE CODE 2ψCOMMON MODULE CODE 3ψCOMMON MODULE CODE 4ψCOMMON MODULE CODE 5ψCOMMON MODULE CODE 6" as common_module_code, "MODULE 1 FEEψMODULE 2 FEEψMODULE 3 FEEψMODULE 4 FEEψMODULE 5 FEEψMODULE 6 FEE" as module_fee, "MODULE 1 FEE INSψMODULE 2 FEE INSψMODULE 3 FEE INSψMODULE 4 FEE INSψMODULE 5 FEE INSψMODULE 6 FEE INS" as module_fee_ins, "MODULE 1 CREDITψMODULE 2 CREDITψMODULE 3 CREDITψMODULE 4 CREDITψMODULE 5 CREDITψMODULE 6 CREDIT" as module_credit, "PHONE" as phone, "MOBILE" as mobile, "ADDRESS" as address, "COUNTRY" as country, "GOV GRANT" as gov_grant, "STATUS" as status, "CURRENCY" as currency, "INSTALLMENT" as installment, "PAYMENT AMOUNT" as amount, "PAYMENT MODE" as payment_mode, "MYT MONEY REF" as myt_ref_no, "PAYMENT DATE" as payment_date, "USER_ID" as user_id
UNION ALL 
select a.code as rdap,  GROUP_CONCAT(DISTINCT bill.billNo SEPARATOR 'ψ' ) as rdbl, per.nationalID as nic, u.code as learner_id,
u.firstName as first_name, u.lastName as last_name, '' as maiden_name, b.batchName as intake, b.batchName as intake_formatted,
per.emailId as login_email, per.emailId as contact_email, 
p.programNameToBePrint as programme,
pcd.cf1 as programCodeForAccounting,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(ccd.cf2, ' ')) SEPARATOR 'ψ' ) AS module_id,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(c.courseName, ' ')) SEPARATOR 'ψ' ) AS module,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(c.courseCode, ' ')) SEPARATOR 'ψ' ) AS module_code,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(c.courseCode, ' ')) SEPARATOR 'ψ' ) AS common_module_code,
GROUP_CONCAT(DISTINCT concat(IFNULL(pt.code, ' '),'$',c.id,'$',IFNULL(fshc.feeAmount, '0'))  SEPARATOR 'ψ' ) AS module_fee,
GROUP_CONCAT(DISTINCT concat(IFNULL(pt.code, ' '),'$',c.id,'$',IFNULL(fshc.feeAmount, '0'))  SEPARATOR 'ψ' ) AS module_fee_ins,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(c.courseCredits, ' ')) SEPARATOR 'ψ' ) AS module_credit,
per.phoneNo as phone, per.mobileNumber as mobile,
concat(adr.addressText, ct.cityName) as address, cnt.countryName as country, 
CASE WHEN st.seatCode = 'Grant' THEN 'Yes' ELSE 'No' END AS gov_grant,
'Active' as status, 
GROUP_CONCAT(DISTINCT cr.currencyCode SEPARATOR 'ψ')  as currency, 
CASE WHEN st.seatCode != 'Grant' AND pt.code != 'AF' THEN 'Yes' ELSE 'No' END AS installment,
GROUP_CONCAT(DISTINCT concat(c.id,'$',fadjd.id,'$',IFNULL(fadjd.adjustedAmount, "0")) SEPARATOR 'ψ' ) as amount,
CASE WHEN rh.voucherMode = 'Bank' THEN 'OU Finance Dept' ELSE 'Offline' END AS payment_mode,
rpi.instrumentNo AS myt_ref_no, DATE(rh.transactionDate) AS payment_date,
u.code AS user_id
from receipt_header rh 
join fee_adjustment_master fadj on fadj.receiptHeaderId = rh.id and rh.status = 'SETTLED'
join fee_adjustment_details fadjd on fadjd.adjustmentMasterId = fadj.id
join bill_header bill on fadjd.billHeaderId = bill.id
join currency cr on rh.currencyId = cr.id
JOIN users u ON rh.studentId = u.id
JOIN students s ON u.id = s.userId
JOIN admission ad ON u.id = ad.studentId AND ad.activeStatus IS TRUE
JOIN program_batch_students pbs ON ad.id = pbs.admissionId 
JOIN student_course_enrollment sce ON pbs.admissionId = sce.admissionId AND pbs.progBatchPeriodConfigId = sce.programBatchPeriodConfigId and sce.billId = bill.id
join prog_batch_period_config period on sce.programBatchPeriodConfigId = period.id and period.programPeriodSeq = 1
JOIN course_variants cv ON sce.courseVarientId = cv.id
JOIN courses c ON cv.courseId = c.id
JOIN bill_fee_plan_rule_stage bfprs ON bill.id = bfprs.billId
JOIN fee_stage_head_config fshc ON bfprs.feeStageHeadConfigId = fshc.id
JOIN fee_plan_rule_stage fprs ON fshc.feePlanRuleStageId = fprs.id
JOIN fee_plan_rules fpr ON fprs.feePlanRuleId = fpr.id
JOIN payment_term pt ON fpr.paymentTermId = pt.id
JOIN prog_batch_seat_config pbsc ON pbs.progBatchSeatConfigId = pbsc.id
JOIN seat_types st ON pbsc.seatTypeId = st.id
JOIN batches b ON pbsc.programBatchId = b.id
JOIN programs p ON b.programId = p.id
JOIN persons per ON s.personId = per.id
left JOIN program_cd pcd ON p.id = pcd.programId
left JOIN course_cd ccd ON c.id = ccd.courseId
left JOIN person_addresses pad on per.id=pad.personId
left JOIN address adr ON pad.addressId = adr.id AND adr.addressTypeId = 5
left JOIN country cnt ON adr.countryId = cnt.id
left join city ct on adr.cityId = ct.id
left JOIN receipt_payment_instrument rpi ON rh.id = rpi.receiptHeaderId
LEFT JOIN application_program ap ON ad.applicationProgramId = ap.id
LEFT JOIN application a ON ap.applicationId = a.id
where date(fadjd.adjustmentDate) = transdate
GROUP BY u.id,p.id;
END $$
DELIMITER ;