DELIMITER $$
DROP PROCEDURE IF EXISTS getModuleReRegistrationDetails $$
CREATE PROCEDURE getModuleReRegistrationDetails(IN transdate DATE)
BEGIN
select "PTN" as receipt_no, "STATUS" as status, "RDAP" as rdap, "STUDENT ID" as student_id, "FIRST NAME" as first_name, "LAST NAME" as last_name, "MAIDEN NAME" as maiden_name, "STUDENT INTAKE" as intake, "STUDENT INTAKE CODE FOR ACCOUNTING" as intake_formatted, "PAYMENT SEMESTER" as payment_semester,  "PROGRAMME" as programme, "PROGRAMME CODE FOR ACCOUTING" as programCodeForAccounting, "MODULE ID" as module_id, "MODULES" as module, "MODULE CODE" as module_code, "COMMON MODULE CODE" as common_module_code, "MODULE CREDIT" as module_credit, "MODULE FEE" as module_fee, "MODULE FEE INS" as module_fee_ins, "GOV GRANT" as gov_grant, "CURRENCY" as currency, "INSTALLMENT" as installment, "TOTAL" as total, "PENALTY FEE" as penalty_fee, "NET TOTAL" as net_total, "PAYMENT FOR" as payment_for, "PAYMENT TYPE" as payment_type, "DATE PAID ON" as paid_on,"DATE PROCESSED" as processed_on, "MYT MERCHANT TRADE NO" as myt_merch_ref_no,"MYT TRADE NO" as myt_trade_no, "REMARKS" as remarks, "USER_ID" as user_id
UNION ALL 
select 
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(rh.receiptNo, ' ')) SEPARATOR 'ψ' ) AS receipt_no,
'Active' as status,  a.code as rdap,  u.code AS student_id,
u.firstName as first_name, u.lastName as last_name, '' as maiden_name, b.batchName as intake, b.batchName as intake_formatted,
GROUP_CONCAT(DISTINCT period.printName SEPARATOR '-' ) AS payment_semester, p.programNameToBePrint as programme, pcd.cf1 as programCodeForAccounting,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(ccd.cf2, ' ')) SEPARATOR 'ψ' ) AS module_id,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(c.courseName, ' ')) SEPARATOR 'ψ' ) AS module,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(c.courseCode, ' ')) SEPARATOR 'ψ' ) AS module_code,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(c.courseCode, ' ')) SEPARATOR 'ψ' ) AS common_module_code,
GROUP_CONCAT(DISTINCT concat(c.id,'$',IFNULL(c.courseCredits, ' ')) SEPARATOR 'ψ' ) AS module_credit,
GROUP_CONCAT(DISTINCT concat(IFNULL(pt.code, ' '),'$',c.id,'$',IFNULL(fshc.feeAmount, '0'))  SEPARATOR 'ψ' ) AS module_fee,
GROUP_CONCAT(DISTINCT concat(IFNULL(pt.code, ' '),'$',c.id,'$',IFNULL(fshc.feeAmount, '0'))  SEPARATOR 'ψ' ) AS module_fee_ins,
CASE WHEN st.seatCode = 'Grant' THEN 'Yes' ELSE 'No' END AS gov_grant,
GROUP_CONCAT(DISTINCT cr.currencyCode SEPARATOR 'ψ')  as currency, 
GROUP_CONCAT(DISTINCT concat(c.id,'$', CASE WHEN st.seatCode != 'Grant' AND pt.code != 'AF' THEN 'Yes' ELSE 'No' END)  SEPARATOR 'ψ' ) AS installment,
GROUP_CONCAT(DISTINCT concat(c.id,'$',fadjd.id,'$',IFNULL(fadjd.adjustedAmount, "0")) SEPARATOR 'ψ' ) as total,
GROUP_CONCAT(DISTINCT concat(c.id,'$',fadjd.id,'$',IFNULL(latefee.totalAmount, "0")) SEPARATOR 'ψ' ) as penalty_fee,
 0 as net_total, "Reregistration" AS payment_for,
CASE WHEN rh.voucherMode = 'Bank' THEN 'OU Finance Dept' ELSE 'Offline' END AS payment_type,
DATE(rh.transactionDate) AS paid_on,DATE(rh.transactionDate) AS processed_on,
rpi.instrumentNo AS myt_merchant_trade_no,rpi.instrumentNo AS myt_trade_no,
rh.narration AS remarks, u.code AS user_id
from receipt_header rh 
join fee_adjustment_master fadj on fadj.receiptHeaderId = rh.id and rh.status = 'SETTLED'
join fee_adjustment_details fadjd on fadjd.adjustmentMasterId = fadj.id
join bill_header bill on fadjd.billHeaderId = bill.id
join currency cr on rh.currencyId = cr.id
JOIN users u ON rh.studentId = u.id
JOIN students s ON u.id = s.userId
JOIN admission ad ON u.id = ad.studentId AND ad.activeStatus IS TRUE
JOIN program_batch_students pbs ON ad.id = pbs.admissionId 
JOIN student_course_enrollment sce ON pbs.admissionId = sce.admissionId AND pbs.progBatchPeriodConfigId = sce.programBatchPeriodConfigId and sce.billId = bill.id
join prog_batch_period_config period on sce.programBatchPeriodConfigId = period.id and period.programPeriodSeq > 1
JOIN course_variants cv ON sce.courseVarientId = cv.id
JOIN courses c ON cv.courseId = c.id
JOIN bill_fee_plan_rule_stage bfprs ON bill.id = bfprs.billId
JOIN fee_stage_head_config fshc ON bfprs.feeStageHeadConfigId = fshc.id
JOIN fee_plan_rule_stage fprs ON fshc.feePlanRuleStageId = fprs.id
JOIN fee_plan_rules fpr ON fprs.feePlanRuleId = fpr.id
JOIN payment_term pt ON fpr.paymentTermId = pt.id
JOIN prog_batch_seat_config pbsc ON pbs.progBatchSeatConfigId = pbsc.id
JOIN seat_types st ON pbsc.seatTypeId = st.id
JOIN batches b ON pbsc.programBatchId = b.id
JOIN programs p ON b.programId = p.id
JOIN persons per ON s.personId = per.id
left JOIN program_cd pcd ON p.id = pcd.programId
left JOIN course_cd ccd ON c.id = ccd.courseId
left JOIN person_addresses pad on per.id=pad.personId
left JOIN address adr ON pad.addressId = adr.id AND adr.addressTypeId = 5
left JOIN country cnt ON adr.countryId = cnt.id
left join city ct on adr.cityId = ct.id
LEFT JOIN bill_header latefee ON bill.id = latefee.billHeaderForLateFeeId and latefee.billStatus = 'SETTLED'
left JOIN receipt_payment_instrument rpi ON rh.id = rpi.receiptHeaderId
LEFT JOIN application_program ap ON ad.applicationProgramId = ap.id
LEFT JOIN application a ON ap.applicationId = a.id
where date(fadjd.adjustmentDate) = transdate
GROUP BY u.id,p.id;
END $$
DELIMITER ;