DELIMITER $$
DROP PROCEDURE IF EXISTS V20250609162913__Insert_AddNewColsAdmApprovalLoader $$
CREATE PROCEDURE V20250609162913__Insert_AddNewColsAdmApprovalLoader()
BEGIN
	
SET SQL_SAFE_UPDATES = 0;
IF EXISTS (SELECT * FROM import_utility_master WHERE screenName='Import Bulk Admission Approval' AND code ='bulkAdmissionApproval') THEN 

SET @importUtilityMasterId=(SELECT id FROM import_utility_master WHERE screenName='Import Bulk Admission Approval' AND code ='bulkAdmissionApproval');

#-------------------------Is School------------------------------------------------------------------------------------------

IF EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_CODE_NAME_HEADER' AND isSchool='1')) THEN 
UPDATE loader_header SET `headerCode` = 'PROGRAM_CODE_HEADER', `defaultHeaderLabel` = 'Program Code', `headerLabel` = 'Program Code'
WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_CODE_NAME_HEADER' AND isSchool='0';
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_NAME_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('PROGRAM_NAME_HEADER', 'Program Name', 'Program Name', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='SECTION_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SECTION_HEADER', 'Section', 'Section', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='REMARK_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REMARK_HEADER', 'Approve Admission Remark', 'Approve Admission Remark', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='ADMISSION_DATE_HEADER' AND isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ADMISSION_DATE_HEADER', 'Admission Date', 'Admission Date', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#-------------------------Is College------------------------------------------------------------------------------------------

IF EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_CODE_NAME_HEADER' AND isSchool='0')) THEN 
UPDATE loader_header SET `headerCode` = 'PROGRAM_CODE_HEADER', `defaultHeaderLabel` = 'Program Code', `headerLabel` = 'Program Code'
WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_CODE_NAME_HEADER' AND isSchool='0';
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='PROGRAM_NAME_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('PROGRAM_NAME_HEADER', 'Program Name', 'Program Name', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='SECTION_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SECTION_HEADER', 'Section', 'Section', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='REMARK_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REMARK_HEADER', 'Approve Admission Remark', 'Approve Admission Remark', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId AND headerCode='ADMISSION_DATE_HEADER' AND isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ADMISSION_DATE_HEADER', 'Admission Date', 'Admission Date', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

END IF; 
SET SQL_SAFE_UPDATES = 1;

END $$
CALL V20250609162913__Insert_AddNewColsAdmApprovalLoader() $$
DROP PROCEDURE IF EXISTS V20250609162913__Insert_AddNewColsAdmApprovalLoader $$
DELIMITER ;