DELIMITER $$

DROP PROCEDURE IF EXISTS getStudentTeacherDetails $$

CREATE PROCEDURE getStudentTeacherDetails(
    IN locationCode TINYTEXT,
    IN academicTerm TINYTEXT,
    IN programCode TINYTEXT,
    IN studentCode TINYTEXT
)
BEGIN
    SET @query = CONCAT(
        "SELECT al.locationCode AS locationCode, aterm.itemValue AS academicTerm, ",
        "p.id AS programId, p.programCode AS programCode, period.programPeriodSeq AS programPeriodSequence, ",
        "pcord.printName AS programManagerName, pcord.emailId AS programManagerEmail, ",
        "st.code AS studentId, st.firstName AS studentFirstName, st.lastName AS studentLastName, st.emailId AS studentEmail, ",
        "sponsor.printName AS sponsorName, sponsor.emailId AS sponsorEmail, sponsor.haveAccessToLearner AS hasAccessToStudent, ",
        "pr.motivation AS studentClass, cv.id AS courseVariantId, cv.courseVariantCode AS courseVarianCode, ",
        "pbcp.whetherOptional AS isOptional, ccat.categoryName AS courseCategoryValue, ",
        "staff.printName AS teacherName, staff.emailId AS teacherEmail ",
        "FROM student_course_enrollment sce ",
        "JOIN prog_batch_period_config period ON sce.programBatchPeriodConfigId = period.id ",
        "JOIN batches b ON period.programBatchId = b.id ",
        "JOIN programs p ON b.programId = p.id ",
        "JOIN academy_location al ON p.academyLocationId = al.id ",
        "JOIN users pcord ON p.approver = pcord.id ",
        "JOIN academic_term aterm ON period.academicTermId = aterm.id ",
        "JOIN course_variants cv ON sce.courseVarientId = cv.id ",
        "JOIN courses c ON cv.courseId = c.id ",
        "JOIN admission a ON sce.admissionId = a.id ",
        "JOIN students s ON s.userId = a.studentId ",
        "JOIN users st ON s.userId = st.id ",
        "JOIN persons pr ON s.personId = pr.id ",
        "LEFT JOIN course_category ccat ON c.courseCategoryId = ccat.id ",
        "LEFT JOIN person_relationships perel ON pr.id = perel.personId AND UPPER(perel.relationship) = 'MOTHER' ",
        "LEFT JOIN persons sponsor ON perel.relatedPersonId = sponsor.id ",
        "LEFT JOIN program_batch_course_param pbcp ON pbcp.courseVarientId = cv.id AND period.id = pbcp.progBatchPeriodConfigId ",
        "LEFT JOIN prog_batch_course_faculty pbcf ON pbcf.progBatchCourseParamId = pbcp.id ",
        "LEFT JOIN users staff ON pbcf.facultyId = staff.id ",
        "WHERE al.locationCode = '", locationCode, "' ",
        "AND aterm.itemValue = '", academicTerm, "' "
    );

    IF programCode IS NOT NULL THEN
        SET @query = CONCAT(@query, "AND p.programCode = '", programCode, "' ");
    END IF;

    IF studentCode IS NOT NULL THEN
        SET @query = CONCAT(@query, "AND st.code = '", studentCode, "' ");
    END IF;

    SET @query = CONCAT(@query, ";");

    PREPARE stmt FROM @query;
    EXECUTE stmt;
    DEALLOCATE PREPARE stmt;
END $$

DELIMITER ;
