-- V1__create_GetCourseModulesAndVariants.sql

DROP PROCEDURE IF EXISTS GetCourseModulesAndVariants;
DELIMITER //

CREATE PROCEDURE GetCourseModulesAndVariants (
    IN programId BIGINT,
    IN academicTermId BIGINT
)
BEGIN
    SELECT 
        cs.courseCode AS MODID,
        cv.courseVariantCode AS MODINSTID
    FROM admission adm
    LEFT JOIN programs ps ON adm.programId = ps.id
    LEFT JOIN student_course_enrollment sce ON sce.admissionId = adm.id
    LEFT JOIN prog_batch_period_config pbpc ON pbpc.id = sce.programBatchPeriodConfigId
    LEFT JOIN program_batch_students pbs ON pbs.admissionId = adm.id
    LEFT JOIN course_variants cv ON sce.courseVarientId = cv.id
    LEFT JOIN courses cs ON cs.id = cv.courseId
    LEFT JOIN students stu ON adm.studentId = stu.userId
    LEFT JOIN users us ON us.id = stu.userId
    WHERE ps.id = programId
      AND pbpc.academicTermId = academicTermId
      AND sce.exitDate IS NULL
      AND pbs.isCurrentPeriod = 1
      AND pbs.isCurrentSection = 1
      AND cs.courseCode IN (
          SELECT DISTINCT cs.courseCode
          FROM admission adm
          LEFT JOIN programs ps ON adm.programId = ps.id
          LEFT JOIN student_course_enrollment sce ON sce.admissionId = adm.id
          LEFT JOIN prog_batch_period_config pbpc ON pbpc.id = sce.programBatchPeriodConfigId
          LEFT JOIN program_batch_students pbs ON pbs.admissionId = adm.id
          LEFT JOIN course_variants cv ON sce.courseVarientId = cv.id
          LEFT JOIN courses cs ON cs.id = cv.courseId
          LEFT JOIN students stu ON adm.studentId = stu.userId
          LEFT JOIN users us ON us.id = stu.userId
          WHERE ps.id = programId
            AND pbpc.academicTermId = academicTermId
            AND sce.exitDate IS NULL
            AND pbs.isCurrentPeriod = 1
            AND pbs.isCurrentSection = 1
          GROUP BY adm.id, cs.id, cs.courseCode
      )
    ORDER BY cs.courseCode, cv.courseVariantCode;
END //

DELIMITER ;