DELIMITER $$
DROP PROCEDURE IF EXISTS V20250616110851__Insert_BRITTS_MARKSHEET $$
CREATE PROCEDURE V20250616110851__Insert_BRITTS_MARKSHEET()
BEGIN
IF NOT EXISTS (SELECT * FROM `report_template` WHERE templateCode = 'BRITTS_UNIVERSITY_MARKSHEET') THEN 
set @Britts = (select id from report_type WHERE typeName = 'Mark Sheet');

INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`,`templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@Britts, 'BRITTS_UNIVERSITY_MARKSHEET', 'Britts University Marksheet', 'BRITTS_UNIVERSITY_MARKSHEET.png', 'BRITTS_UNIVERSITY_MARKSHEET_CommonReport.jasper','EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'BRITTS_UNIVERSITY_MARKSHEET.jasper', 'AcademiaLogo.png');
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE  templateCode='BRITTS_UNIVERSITY_MARKSHEET' and templateName='Britts University Marksheet')) THEN 
SET @reportTemplateId = (SELECT id FROM `report_template` WHERE  templateCode='BRITTS_UNIVERSITY_MARKSHEET' and templateName='Britts University Marksheet');
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_TEMR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_TEMR', 'Term End Marksheet - Resit', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_TEM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_TEM', 'Term End Marksheet', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_STD_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_STD_ID', 'Student ID  :', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_STD_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_STD_NAME', 'Student Name  :', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_DOB')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_DOB', 'Date of Birth  :', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_PROGRAM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_PROGRAM', 'Program  :', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_COHORT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_COHORT', 'Cohort :', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_DOR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_DOR', 'Date of Result  :', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_TRIMESTER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_TRIMESTER', 'Trimester', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_MODULE_CODE_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_MODULE_CODE_NAME', 'Module Code – Name', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_MODULE_CREDIT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_MODULE_CREDIT', 'Module Credit', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_MARKS_OBTAINED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_MARKS_OBTAINED', 'Marks Obtained', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_INTERNAL_MARKS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_INTERNAL_MARKS', 'Internal Marks', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_ATTENDANCE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_ATTENDANCE', 'Attendance', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_AS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_AS', 'Assessment Scores', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_ETM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_ETM', 'End Term Marks', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_TMO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_TMO', 'Total Marks Obtained', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_EC')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_EC', 'Earned Credit', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_RESULT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_RESULT', 'Result', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_TOTAL')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_TOTAL', 'Total', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_OTP')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_OTP', 'Overall Trimester Percentage', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_NOTE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_NOTE', 'Note:-', '1', now());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=@reportTemplateId and keyValue='TRANS_NOTE_VALUE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTemplateId, 'TRANS_NOTE_VALUE', 'i. Contact Student Affairs team to discuss your resit and course completion plan.\nii. All failed modules can be attempted again through resit.\niii. Minimum marks required to achieve module credit is 40 marks.\niv. * Condoned Pass by Grace marks through Exam Board.', '1', now());
END IF; 

END $$
CALL V20250616110851__Insert_BRITTS_MARKSHEET() $$
DROP PROCEDURE IF EXISTS V20250616110851__Insert_BRITTS_MARKSHEET $$
DELIMITER ;