DELIMITER $$
DROP PROCEDURE IF EXISTS V20250620144930__Create_terms_and_conditions_accept_logs $$
CREATE PROCEDURE V20250620144930__Create_terms_and_conditions_accept_logs()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='terms_and_conditions_acceptance_logs')) THEN 
CREATE TABLE `terms_and_conditions_acceptance_logs` (
  `id` BIGINT NOT NULL  AUTO_INCREMENT,
  `userId` BIGINT DEFAULT NULL,
  `externalUserId` BIGINT DEFAULT NULL,
  `acceptanceDate` DATE NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_terms_and_conditions_acceptance_logs_User_idx`(`userId`),
  INDEX `fk_terms_and_conditions_acceptance_logs_ExtUser_idx`(`externalUserId`),
  INDEX `fk_terms_and_conditions_User_idx` (`lastUpdatedBy`) ,
  
  CONSTRAINT `fk_terms_and_conditions_acceptance_logs_User_idx` 
	FOREIGN KEY (`userId`) 
	REFERENCES `users`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
	
  CONSTRAINT `fk_terms_and_conditions_acceptance_logs_ExtUser_idx` 
	FOREIGN KEY (`externalUserId`) 
	REFERENCES `external_users`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
 
  CONSTRAINT `fk_terms_and_conditions_acceptance_logs_to_User_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 
 
END $$
CALL V20250620144930__Create_terms_and_conditions_accept_logs () $$ 
DROP PROCEDURE IF EXISTS V20250620144930__Create_terms_and_conditions_accept_logs $$ 
DELIMITER ;
