DELIMITER $$
DROP PROCEDURE IF EXISTS V20250707133013__Insert_AddressFieldsToBulkAdmLoader $$
CREATE PROCEDURE V20250707133013__Insert_AddressFieldsToBulkAdmLoader()
BEGIN

IF EXISTS ((SELECT * FROM import_utility_master WHERE code='bulkadmission')) THEN

SET @importUtilityMasterId=(SELECT MAX(id) FROM import_utility_master WHERE code='bulkadmission');

#-------------------------Is School------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'FULL_ADDRESS_HEADER' AND isSchool=1  AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('FULL_ADDRESS_HEADER' ,'Full Address' , 1,  sysdate()  , 1 , 'Full Address' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ADDRESS_COUNTRY_HEADER' AND isSchool=1 AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('ADDRESS_COUNTRY_HEADER' ,'Address Country' , 1,  sysdate()  , 1 , 'Address Country' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'STATE_HEADER' AND isSchool=1 AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('STATE_HEADER' ,'State' , 1,  sysdate()  , 1 , 'State' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'CITY_ADDRESS_HEADER' AND isSchool=1 AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('CITY_ADDRESS_HEADER' ,'City-Address' , 1,  sysdate()  , 1 , 'City-Address' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'PINCODE_HEADER' AND isSchool=1 AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('PINCODE_HEADER' ,'Pincode' , 1,  sysdate()  , 1 , 'Pincode' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

#-------------------------Is College------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'FULL_ADDRESS_HEADER' AND isSchool=0  AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('FULL_ADDRESS_HEADER' ,'Full Address' , 0,  sysdate()  , 1 , 'Full Address' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ADDRESS_COUNTRY_HEADER' AND isSchool=0 AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('ADDRESS_COUNTRY_HEADER' ,'Address Country' , 0,  sysdate()  , 1 , 'Address Country' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'STATE_HEADER' AND isSchool=0 AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('STATE_HEADER' ,'State' , 0,  sysdate()  , 1 , 'State' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'CITY_ADDRESS_HEADER' AND isSchool=0 AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('CITY_ADDRESS_HEADER' ,'City-Address' , 0,  sysdate()  , 1 , 'City-Address' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'PINCODE_HEADER' AND isSchool=0 AND importUtilityMasterId=@importUtilityMasterId)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`,`isVisible`,`defaultValue`) 
VALUES ('PINCODE_HEADER' ,'Pincode' , 0,  sysdate()  , 1 , 'Pincode' , 0, 0 ,@importUtilityMasterId,0,null); 
END IF;

END IF;

END $$
CALL V20250707133013__Insert_AddressFieldsToBulkAdmLoader() $$
DROP PROCEDURE IF EXISTS V20250707133013__Insert_AddressFieldsToBulkAdmLoader $$
DELIMITER ;