DELIMITER $$
DROP PROCEDURE IF EXISTS V20250714180840__Alter_Icici_Payment_Gateway_diaplayOrder $$
CREATE PROCEDURE V20250714180840__Alter_Icici_Payment_Gateway_diaplayOrder()
BEGIN

IF EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'ICICI') THEN 

    SET @standardMasterId = (
        SELECT id FROM standard_master
        WHERE tableName = 'icici_payment_gateway'
        ORDER BY id DESC LIMIT 1
    );

    -- Correct updates with WHERE clauses
    IF EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'merchantId' AND standardMasterId = @standardMasterId) THEN
        UPDATE standard_master_items SET `diaplayOrder` = 2 WHERE dbFieldName = 'merchantId' AND standardMasterId = @standardMasterId;
    END IF;

    IF EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'paymentMode' AND standardMasterId = @standardMasterId) THEN
        UPDATE standard_master_items SET `diaplayOrder` = 3 WHERE dbFieldName = 'paymentMode' AND standardMasterId = @standardMasterId;
    END IF;

    IF EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'aesKey' AND standardMasterId = @standardMasterId) THEN
        UPDATE standard_master_items SET `diaplayOrder` = 4 WHERE dbFieldName = 'aesKey' AND standardMasterId = @standardMasterId;
    END IF;

    IF EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'currencyCode' AND standardMasterId = @standardMasterId) THEN
        UPDATE standard_master_items SET `diaplayOrder` = 5 WHERE dbFieldName = 'currencyCode' AND standardMasterId = @standardMasterId;
    END IF;

    IF EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'submerchantId' AND standardMasterId = @standardMasterId) THEN
        UPDATE standard_master_items SET `diaplayOrder` = 6 WHERE dbFieldName = 'submerchantId' AND standardMasterId = @standardMasterId;
    END IF;

    IF EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'environmentURL' AND standardMasterId = @standardMasterId) THEN
        UPDATE standard_master_items SET `diaplayOrder` = 7 WHERE dbFieldName = 'environmentURL' AND standardMasterId = @standardMasterId;
    END IF;

    IF EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'cipherKey' AND standardMasterId = @standardMasterId) THEN
        UPDATE standard_master_items SET `diaplayOrder` = 8 WHERE dbFieldName = 'cipherKey' AND standardMasterId = @standardMasterId;
    END IF;

    IF EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'customField1' AND standardMasterId = @standardMasterId) THEN
        UPDATE standard_master_items SET `diaplayOrder` = 9 WHERE dbFieldName = 'customField1' AND standardMasterId = @standardMasterId;
    END IF;

END IF;
END $$
CALL V20250714180840__Alter_Icici_Payment_Gateway_diaplayOrder() $$
DROP PROCEDURE IF EXISTS V20250714180840__Alter_Icici_Payment_Gateway_diaplayOrder $$
DELIMITER ;