DELIMITER $$
DROP PROCEDURE IF EXISTS getSAGEInvoiceData $$
CREATE PROCEDURE `getSAGEInvoiceData` (
    IN academyLocationId BIGINT,
    IN studentCode varchar(25),
    IN billingFromDate DATE,
    IN billingToDate DATE,
    IN creationFromDate DATE,
    IN creationToDate DATE,
    IN lastUpdatedFromDate DATE,
    IN lastUpdatedToDate DATE
)
BEGIN
    SELECT 
        bh.billingDate AS `invoiceDate`,
        u.code AS `studentAccountNumber`,
        GROUP_CONCAT(DISTINCT cc.itemcode SEPARATOR ',') AS `costCentres`,
		SUM(bfprs.billableAmount) AS `invoiceAmount`,
		c.currencyCode as `currencyCodes`,
        bh.reasonForManualBill AS `invoiceDescription`,
        bh.billNo AS `invoiceReference`,
        bh.raiseBillType AS `invoiceType`,
        bh.billStatus AS `status`,
        DATE(bh.creationDateTime) AS `createdDate`,
        DATE(bh.lastUpdate) AS `updatedDate`
    FROM bill_header bh
    LEFT JOIN users u ON bh.studentId = u.id
    LEFT JOIN academy_location al ON bh.academyLocationId = al.id
    LEFT JOIN bill_fee_plan_rule_stage bfprs ON bh.id = bfprs.billId
    LEFT JOIN fee_stage_head_config fshc ON bfprs.feeStageHeadConfigId = fshc.id
    LEFT JOIN cost_centre cc ON fshc.costCentreId = cc.id
	LEFT JOIN currency c ON bh.currencyId = c.id
    WHERE bh.raiseBillCategory = 'BILL_RECEIVABLE'
      AND bfprs.billableAmount > 0
      AND (academyLocationId IS NULL OR al.id = academyLocationId)
      AND (studentCode IS NULL OR u.code = studentCode)
      AND (billingFromDate IS NULL OR bh.billingDate >= billingFromDate)
      AND (billingToDate IS NULL OR bh.billingDate <= billingToDate)
      AND (creationFromDate IS NULL OR DATE(bh.creationDateTime) >= creationFromDate)
      AND (creationToDate IS NULL OR DATE(bh.creationDateTime) <= creationToDate)
      AND (lastUpdatedFromDate IS NULL OR DATE(bh.lastUpdate) >= lastUpdatedFromDate)
      AND (lastUpdatedToDate IS NULL OR DATE(bh.lastUpdate) <= lastUpdatedToDate)
    GROUP BY bh.id;
END$$

DELIMITER ;