DELIMITER $$
DROP PROCEDURE IF EXISTS V20250902160646__Create_GUARDIANReceiptAcknowledgementEvent $$
CREATE PROCEDURE V20250902160646__Create_GUARDIANReceiptAcknowledgementEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM system_msg_event WHERE `code`='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT' limit 1)) THEN 
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category); 
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='FEE_PAYMENT');
IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='STUDENT_PAYMENT_ACKNOWLEDGEMENT' and parentCategory=@parentcategoryId limit 1)) THEN 
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+2,@parentcategoryId,'STUDENT_PAYMENT_ACKNOWLEDGEMENT');
END IF;

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT_PAYMENT_ACKNOWLEDGEMENT');

IF NOT EXISTS ((SELECT * FROM system_msg_event WHERE `code`='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT' limit 1)) THEN 
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'GUARDIAN_RECEIPT_ACKNOWLEDGEMENT', 'Guardian Receipt Acknowledgement', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'GUARDIAN_RECEIPT_ACKNOWLEDGEMENT');
END IF;

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_DL', 'SQL');

-- Recipient Infor data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT');


-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS USER_ID
FROM
    receipt_header T1
WHERE
    T1.id IN (namedParams)",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`printName` AS PRINT_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T7.`emailId` AS EMAIL_ID,
    T7.`mobileNumber` AS MOBILE_NO,
    T7.`mobileCountryCode` AS MOBILE_CODE,
    T1.`amount` AS TOTAL_AMOUNT,
    T6.`currencyCode` AS CURRENCY_CODE,
    T8.`code` AS STUDENT_ID,
    T9.`displayName` AS ACADEMY_NAME,
    T7.`printName` AS GUARDIAN_NAME,
    DATE_FORMAT(T1.`transactionDate`, '%d-%m-%Y') AS RECEIPT_DATE
    
FROM
    receipt_header T1
       LEFT JOIN
    students T2 ON T2.userId = T1.studentId
      LEFT JOIN
    users T8 ON T2.userId = T8.id
         LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    academy_location T9 ON T9.id = T1.academyLocationId    
		LEFT JOIN
    person_relationships T5 ON T3.id = T5.personId
		LEFT JOIN
    persons T7 ON T5.relatedPersonId = T7.id
        LEFT JOIN
    salutations T4 ON T4.id = T3.salutationId
         LEFT JOIN
    currency T6 ON T6.id = T1.currencyId
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
WHERE
T1.id IN (namedParams) 
and T5.relationship='GUARDIAN' and T5.whetherDeleted=false group by T1.id",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "PRINTNAME",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "amount",
            "resultKey": "TOTAL_AMOUNT",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "currencyCode",
            "resultKey": "CURRENCY_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "transactionDate",
            "resultKey": "RECEIPT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "receiptNo",
            "resultKey": "RECEIPT_NO",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "STUDENTID",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "ACADEMYNAME",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "GUARDIANNAME",
            "resultKey": "GUARDIAN_NAME",
            "displayCode": "",
            "displayOrder": 12
        }
    ]
}');



SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='STUDENT_PAYMENT_ACKNOWLEDGEMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='GUARDIAN_RECEIPT_ACKNOWLEDGEMENT_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

IF NOT EXISTS ((SELECT * FROM msg_template_config WHERE `code`='Guardian Receipt Acknowledgement' limit 1)) THEN
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Guardian Receipt Acknowledgement',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Guardian Receipt Acknowledgement',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1');
END IF; 

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);

IF NOT EXISTS ((SELECT * FROM msg_template WHERE `subjectLine`='Receipt Generated' limit 1)) THEN
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+1,@msgtemplateconfigId+1,'1','Receipt Generated','<html>
<head>
	<title></title>
</head>
<body data-gr-ext-installed="" data-new-gr-c-s-check-loaded="14.1229.0" data-new-gr-c-s-loaded="14.1229.0">
<p>Dear [GUARDIAN Print Name],</p>

<p>Thank you for using our online registration and payment system.<br />
We hereby acknowledge receipt of payment for [Student Name] amounting to [Currency] [Amount].</p>

<p>To generate the receipt, please log in to your ERP portal.</p>

<p>Regards,<br />
[Academy Location Name]</p>
</body>
</html>

');
END IF; 

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["SALUTATION_NAME"] $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"],A Receipt of amount $recipientData["CURRENCY_CODE"] $recipientData["AMOUNT"] with Recipet no. $recipientData["RECEIPT_NO"] has been generated on $recipientData["TRANSACTION_DATE"].');

END IF; 

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='STUDENT_PAYMENT_ACKNOWLEDGEMENT')) THEN
INSERT INTO `picklist_translation` (`key`, en) VALUES ('STUDENT_PAYMENT_ACKNOWLEDGEMENT', 'Student Payment Acknowledgement');
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='TOTAL_AMOUNT' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','TOTAL_AMOUNT','Amount','Amount','Bedrag','Số lượng',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='Student Id' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','Student Id','Student ID','Student ID','Studente-ID','Mã sinh viên',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='ACADEMY_NAME' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','ACADEMY_NAME','Academy Location Name','Academy Location Name','Akademie Ligging Naam','Tên địa điểm học viện',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='GUARDIAN_NAME' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','GUARDIAN_NAME','Guardian Name','Guardian Name','Naam voog','Tên người giám hộ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='CURRENCY_CODE' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','CURRENCY_CODE','Receipt Currency','Receipt Currency','Ontvangs Geldeenheid','Tiền tệ nhận',now(),1);
END IF;

END $$
CALL V20250902160646__Create_GUARDIANReceiptAcknowledgementEvent () $$ 
DROP PROCEDURE IF EXISTS V20250902160646__Create_GUARDIANReceiptAcknowledgementEvent $$ 
DELIMITER ;