DELIMITER $$

-- Drop the procedure if it already exists
DROP PROCEDURE IF EXISTS UpdateUserSocialInactivation $$

-- Recreate the procedure
CREATE PROCEDURE UpdateUserSocialInactivation(
    IN p_socialId VARCHAR(255),
    IN p_status TINYINT(1),
    IN p_error VARCHAR(1024)
)
BEGIN
    UPDATE users_social
    SET isSsoInactivated = p_status,
        inactivationError = p_error,
        lastUpdate = CURRENT_TIMESTAMP
    WHERE socialId = p_socialId;
END $$

DELIMITER ;
