DELIMITER $$
DROP PROCEDURE IF EXISTS V20250916164344__Update_RegistrationConfirmOnCourseEnroll $$
CREATE PROCEDURE V20250916164344__Update_RegistrationConfirmOnCourseEnroll()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dataProviderId=(SELECT MAX(id) FROM `dydt_data_provider` where providerName='Registration Confirmation Letter Dynamic Document');
 SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
IF  EXISTS ((SELECT 1 FROM dydt_data_line_item WHERE dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO'  AND dataProviderId = @dataProviderId)) THEN  
update dydt_data_line_item set resultColumnsDef  ='COURSE_CODE, COURSE_NAME, COURSE_CREDITS, PERIOD, COURSE_ENROLLMENT_BILL_AMOUNT, MODULE_TYPE, EXAM_DATE, EXAM_START_TIME, EXAM_END_TIME,YEARLY_MODULE' 
, sqlSelectQueryDef =  "SELECT IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,
    IFNULL(co.courseName, c.courseName) AS COURSE_NAME,
FLOOR ( c.courseCredits) 
AS COURSE_CREDITS, 
pbpc.printName AS PERIOD,
ss.examDate AS EXAM_DATE, 
DATE_FORMAT(ss.examStartTime,'%%h:%%i %%p') AS EXAM_START_TIME, 
DATE_FORMAT(ss.examEndTime,'%%h:%%i %%p') AS EXAM_END_TIME,
IF(program_courses.isOfferedYearly = 1,
        'Yes',
        'No') AS YEARLY_MODULE,
bh.totalAmount as COURSE_ENROLLMENT_BILL_AMOUNT,
sce.enrollCourseStatus as MODULE_TYPE
from student_course_enrollment sce
inner 
join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
left join period_year py on pbpc.periodYearId=py.id
inner join drop_down dd on dd.name='Yearly Proof of Registration'
inner 
join admission adm on adm.id=sce.admissionId
inner join course_variants cv on cv.id=sce.courseVarientId
INNER JOIN sections ss on ss.id = sce.sectionId
left join courses c on c.id=cv.courseId
LEFT JOIN courses co ON co.id = c.parentCourseId
LEFT JOIN program_courses ON c.parentCourseId = program_courses.courseId AND pbpc.programBatchId = program_courses.programBatchId
LEFT JOIN bill_header bh on sce.billId=bh.id"
where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO';
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250916164344__Update_RegistrationConfirmOnCourseEnroll () $$
DROP PROCEDURE IF EXISTS V20250916164344__Update_RegistrationConfirmOnCourseEnroll $$
DELIMITER ;