DELIMITER $$
DROP PROCEDURE IF EXISTS V20250917164744__Create_Index_survey_participant $$
CREATE PROCEDURE V20250917164744__Create_Index_survey_participant()
BEGIN

IF EXISTS (SELECT 1 FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='academia_lime_survey_participant' 
  AND column_name='academiaLimeSurveyId') THEN 
CREATE INDEX idx_als_participant_academiaLimeSurveyId
ON academia_lime_survey_participant (academiaLimeSurveyId);
END IF;

IF EXISTS (SELECT 1 FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='academia_lime_survey_participant' 
AND column_name IN ('academiaLimeSurveyId', 'isSurveyEnrolled', 'eamilSent')) THEN 
CREATE INDEX idx_als_participant_academiaLimeSurveyId_enrolled_emailSent
ON academia_lime_survey_participant (academiaLimeSurveyId, isSurveyEnrolled, eamilSent);
END IF;

END $$
CALL V20250917164744__Create_Index_survey_participant () $$ 
DROP PROCEDURE IF EXISTS V20250917164744__Create_Index_survey_participant $$ 
DELIMITER ;