DELIMITER $$
DROP PROCEDURE IF EXISTS V20251029103114__Create_ReceiptAcknowledgmentForApplicant $$
CREATE PROCEDURE V20251029103114__Create_ReceiptAcknowledgmentForApplicant()
BEGIN


 IF NOT EXISTS ((SELECT * FROM `dtprovider` WHERE `dataProviderName`='APPLICANT_PAYMENT_ACKNOWLEDGEMENT')) THEN 
-- Ahdoc msg for Receipt contact

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);

INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICANT_PAYMENT_ACKNOWLEDGEMENT', 'SQL');
END IF;
SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_PAYMENT_ACKNOWLEDGEMENT');

IF NOT EXISTS (SELECT * FROM `msg_recipient_type` WHERE `code` = 'APPLICANT_PAYMENT_ACKNOWLEDGEMENT') THEN
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICANT_PAYMENT_ACKNOWLEDGEMENT');
END IF;

IF NOT EXISTS (
        SELECT * FROM `adhoc_msg_recipient_type`
        WHERE `msgRecipientTypeId` = @msgRecipientId
          AND `distrListProviderId` = @dtproviderId
    ) THEN
        INSERT INTO `adhoc_msg_recipient_type` (`msgRecipientTypeId`, `distrListProviderId`)
        VALUES (@msgRecipientId, @dtproviderId);
    END IF;

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_PAYMENT_ACKNOWLEDGEMENT');
IF NOT EXISTS (SELECT * FROM `sql_dtprovider` WHERE `dataProviderId` = @dtproviderId) THEN
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
	RH.id as ID,
     A.code as APPLICANT_CODE,
    AP.emailId as EMAIL_ID,
    AP.alternateEmailId as ALTERNATE_EMAIL_ID,
    AP.printName AS PRINT_NAME,
    AP.firstName AS FIRST_NAME,
    AP.middleName AS MIDDLE_NAME,
    AP.lastName AS LAST_NAME,
    RH.amount AS AMOUNT,
    RH.receiptNo AS RECEIPT_NO,
    RH.transactionDate AS TRANSACTION_DATE,
    FPM.paymentModeName AS PAYMENT_MODE_NAME,
    RH.voucherMode AS VOUCHER_MODE,
    RH.receiptType AS RECEIPT_TYPE
    
    FROM 
    receipt_header RH
   LEFT JOIN applicant_person AP ON AP.id = RH.applicantId
   LEFT JOIN application A ON A.id = AP.id
   LEFT JOIN receipt_payment_instrument RPI ON RPI.receiptHeaderId = RH.id
   LEFT JOIN fee_payment_modes FPM ON FPM.id = RPI.paymentMode
   WHERE 
    RH.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "Id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "amount",
            "resultKey": "AMOUNT",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "receiptNo",
            "resultKey": "RECEIPT_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "transactionDate",
            "resultKey": "TRANSACTION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "paymentModeName",
            "resultKey": "PAYMENT_MODE_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "voucherMode",
            "resultKey": "VOUCHER_MODE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "receiptType",
            "resultKey": "RECEIPT_TYPE",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "applicant code",
            "resultKey": "APPLICANT_CODE",
            "displayCode": "",
            "displayOrder": 11
        }
    ]
}');
END IF;

 IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='APPLICANT_PAYMENT_ACKNOWLEDGEMENT')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='FEE_PAYMENT');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'APPLICANT_PAYMENT_ACKNOWLEDGEMENT');
 
 END IF;
 
SET @msgsubcategoryId  = (select id from msg_category where code = 'APPLICANT_PAYMENT_ACKNOWLEDGEMENT') ; 
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @msgTemplateConfigId=(SELECT MAX(id) FROM `msg_template_config`);
SET @msgrecipienttypeId=(SELECT id FROM msg_recipient_type WHERE `code`='APPLICANT_PAYMENT_ACKNOWLEDGEMENT');

IF NOT EXISTS (SELECT * FROM `msg_template_config` WHERE `code` = 'Applicant Payment Acknowledgement Email') THEN
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
VALUES(@msgtemplateconfigId+1,'Applicant Payment Acknowledgement Email',@msgsubcategoryId,NULL,@msgrecipienttypeId,1,NULL,NULL,'Applicant Payment Acknowledgement Email',NULL,'',NULL,'','APPROVED',1,'1','System Admin System Admin','1',b'1','English');
 END IF;
 SET @msgTemplateConfigId1=(SELECT id FROM `msg_template_config` WHERE `code` = 'Applicant Payment Acknowledgement Email');
 SET @msgtemplateId1=(SELECT MAX(id)+1 FROM msg_template);
IF NOT EXISTS (SELECT * FROM `msg_template` WHERE `subjectLine` = 'Applicant Payment Acknowledgement Email') THEN 
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId1,@msgtemplateconfigId1,1,'Applicant Payment Acknowledgement Email','<html>
<head>
	<title></title>
</head>
<body>
<p>Dear Sir/Madam...............,</p>

<p>We thank you for using the online registration and payment system. We acknowledge receipt of an amount of Rs ..............</p>

<p>Your acknowledgement ID is ...........</p>

<p>In case you need a receipt, please generate same on the link below:..........</p>

<p>Regards</p>

<p>FINANCE TEAM</p>
</body>
<chatgpt-sidebar data-gpts-theme="light"></chatgpt-sidebar></html>');

END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='APPLICANT_PAYMENT_ACKNOWLEDGEMENT')) THEN
INSERT INTO `picklist_translation` (`key`, en) VALUES ('APPLICANT_PAYMENT_ACKNOWLEDGEMENT', 'Applicant Payment Acknowledgement');
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='APPLICANT_CODE' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','APPLICANT_CODE','Applicant Code','Applicant Code','Aansoeker Kode','Mã người nộp đơn',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='PRINT_NAME' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','PRINT_NAME','Print Name','Print Name','Druk Naam','Tên in',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='FIRST_NAME' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','FIRST_NAME','First Name','First Name','Voornaam','Tên',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='MIDDLE_NAME' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','MIDDLE_NAME','Middle Name','Middle Name','Middelnaam','Tên đệm',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='LAST_NAME' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','LAST_NAME','Last Name','Last Name','Van','Họ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='AMOUNT' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','AMOUNT','Amount','Amount','Bedrag','Số lượng',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='RECEIPT_NO' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','RECEIPT_NO','Acknowledgement ID','Acknowledgement ID','Erkenning ID','ID xác nhận',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='TRANSACTION_DATE' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','TRANSACTION_DATE','Receipt Date','Receipt Date','Ontvangsdatum','Ngày nhận',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='PAYMENT_MODE_NAME' and objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('MESSAGING_TRANSLATIONS','PAYMENT_MODE_NAME','Payment Mode','Payment Mode','Betaalmodus','Phương thức thanh toán',now(),1);
END IF; 
   
END $$
CALL V20251029103114__Create_ReceiptAcknowledgmentForApplicant () $$ 
DROP PROCEDURE IF EXISTS V20251029103114__Create_ReceiptAcknowledgmentForApplicant $$ 
DELIMITER ;
 