DELIMITER $$
DROP PROCEDURE IF EXISTS netsuiteFetchInvoiceToBePushed $$
CREATE PROCEDURE netsuiteFetchInvoiceToBePushed()
BEGIN

SELECT 
    bfpr.id AS id,
        bill.id AS billId,
u.code AS student,
u.id AS studentId,
bill.billNo AS externalId,
bill.billingDate AS date,
bill.dueDate AS dueDate,
bill.reasonForManualBill AS memo,
bill.billingDate AS salesEffectiveDate, 
advisorPerson.shortNameOtherLanguage AS salesRep,
"Sharjah HO Store" AS warehouse,
"Swiss Business School" AS universityName,
b.batchName AS batch,
#"DUBAI BATCH 11" AS batch,
prog.programName AS course,
#"ABS MBA AI UAE" AS course,
st.seatName AS studyLocation,
#"QATAR" AS studyLocation,
ad.admissionDate AS dateOfJoining,
#1053 AS discountItem,	#not found
COALESCE(MIN(SUBSTRING_INDEX(dc.discountCode, '_', 1)), '') AS discountItem,	
#100 AS discountRate,	#not found
IFNULL(bfpr.discountAmount, 0.0) AS discountRate,	
SUBSTRING_INDEX(fh.feeHeadName, '_', 1) AS item,
1 AS quantity,
bfpr.feeAmount AS rate,
st.seatNameOtherLanguage2 AS taxCode
FROM
    bill_header bill 
    left join netsuite_create_invoice_mapping ncim on bill.id=ncim.billHeaderId
    left join bill_fee_plan_rule_stage bfpr on bill.id=bfpr.billId
    left join bill_discount_details bdd on bfpr.id=bdd.billFeePlanRuleStageId
    left join discount_code dc on bdd.discountCode=dc.id
    left join fee_stage_head_config fshc on bfpr.feeStageHeadConfigId=fshc.id
    left join fee_heads fh on fshc.feeHeadId=fh.id
    left join admission ad on bill.admissionId=ad.id
    inner join students s on bill.studentId=s.userId
    inner join users u on s.userId=u.id
    inner join netsuite_create_customer_mapping nccmap on nccmap.academiaUserId=u.id
    inner join persons p on s.personId=p.id
    left join users advisorUser on p.advisorId=advisorUser.id
    left join staffs staff on advisorUser.id=staff.userId
    left join persons advisorPerson on staff.personId=advisorPerson.id
    left join prog_batch_seat_config pbsc on bill.programBatchSeatConfigId=pbsc.id
    left join batches b on pbsc.programBatchId=b.id
    left join programs prog on b.programId=prog.id
    left join seat_types st on pbsc.seatTypeId=st.id
    where bill.raiseBillCategory="BILL_RECEIVABLE" and bill.studentId is not null 
    and bill.billStatus <> "CANCELLED" and ncim.billHeaderId is null
# and bill.id in (63791,15620)
GROUP BY 
    bill.id, bfpr.id;



END $$ 
DELIMITER ;