DELIMITER $$
DROP PROCEDURE IF EXISTS V20251104160725__Insert_Ui_Trans_Section $$
CREATE PROCEDURE V20251104160725__Insert_Ui_Trans_Section()
BEGIN

-- CLASS_TEACHER_CANNOT_BE_SAME_AS_ALTERNATE_CLASS_TEACHER
IF NOT EXISTS (
    SELECT * FROM `ui_translation`
    WHERE objectName='TRANSLATIONS'
      AND keyName='CLASS_TEACHER_CANNOT_BE_SAME_AS_ALTERNATE_CLASS_TEACHER'
) THEN
    INSERT INTO `ui_translation`
    (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
    VALUES (
        'TRANSLATIONS',
        'CLASS_TEACHER_CANNOT_BE_SAME_AS_ALTERNATE_CLASS_TEACHER',
        'Class Teacher cannot be same as Alternate Class Teacher',
        'Class Teacher cannot be same as Alternate Class Teacher',
        'Klasonderwyser kan nie dieselfde as Alternatiewe Klasonderwyser wees nie',
        'Giáo viên chính không thể trùng với giáo viên thay thế',
        NOW(), 1
    );
END IF;


-- ALTERNATE_CLASS_TEACHER
IF NOT EXISTS (
    SELECT * FROM `ui_translation`
    WHERE objectName='TRANSLATIONS'
      AND keyName='ALTERNATE_CLASS_TEACHER'
) THEN
    INSERT INTO `ui_translation`
    (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
    VALUES (
        'TRANSLATIONS',
        'ALTERNATE_CLASS_TEACHER',
        'Alternate Class Teacher',
        'Alternate Class Teacher',
        'Alternatiewe klasonderwyser',
        'Giáo viên thay thế',
        NOW(), 1
    );
END IF;


-- FIRST_COME_FIRST_SERVE
IF NOT EXISTS (
    SELECT * FROM `ui_translation`
    WHERE objectName='TRANSLATIONS'
      AND keyName='FIRST_COME_FIRST_SERVE'
) THEN
    INSERT INTO `ui_translation`
    (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
    VALUES (
        'TRANSLATIONS',
        'FIRST_COME_FIRST_SERVE',
        'First Come First Serve',
        'First Come First Serve',
        'Eerste Kom Eerste Dien',
        'Đến trước phục vụ trước',
        NOW(), 1
    );
END IF;


-- FACULTY_APPROVED
IF NOT EXISTS (
    SELECT * FROM `ui_translation`
    WHERE objectName='TRANSLATIONS'
      AND keyName='FACULTY_APPROVED'
) THEN
    INSERT INTO `ui_translation`
    (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`, `lastUpdatedBy`)
    VALUES (
        'TRANSLATIONS',
        'FACULTY_APPROVED',
        'Faculty Approved',
        'Faculty Approved',
        'Fakulteit goedgekeur',
        'Khoa đã được phê duyệt',
        NOW(), 1
    );
END IF;


END $$
CALL V20251104160725__Insert_Ui_Trans_Section() $$
DROP PROCEDURE IF EXISTS V20251104160725__Insert_Ui_Trans_Section $$
DELIMITER ;