DELIMITER $$
DROP PROCEDURE IF EXISTS V20251110190146__Delete_DuplicateEnrollmentEntries $$
CREATE PROCEDURE V20251110190146__Delete_DuplicateEnrollmentEntries()
BEGIN

-- FOR THE BACKUP 

create table if not exists prog_batch_course_details_duplicate_bckp 
as 
select t1.*
FROM prog_batch_course_details t1
JOIN prog_batch_course_details t2
  ON t1.courseVarientId = t2.courseVarientId
     AND t1.programBatchPeriodConfigId = t2.programBatchPeriodConfigId
     AND t1.admissionId = t2.admissionId
     AND t1.sectionId = t2.sectionId
     AND t1.whetherEnrolled = t2.whetherEnrolled
     AND t1.courseVarientId = t2.courseVarientId
     AND t1.id < t2.id;

-- DATA DELETION (Keep Min id and delete max id) 

set sql_safe_updates = 0;
    
DELETE t1
FROM prog_batch_course_details t1
JOIN prog_batch_course_details t2
  ON t1.courseVarientId = t2.courseVarientId
     AND t1.programBatchPeriodConfigId = t2.programBatchPeriodConfigId
     AND t1.admissionId = t2.admissionId
     AND t1.sectionId = t2.sectionId
     AND t1.whetherEnrolled = t2.whetherEnrolled
     AND t1.courseVarientId = t2.courseVarientId
     AND t1.id < t2.id;

set sql_safe_updates = 1;

END $$
CALL V20251110190146__Delete_DuplicateEnrollmentEntries() $$
DROP PROCEDURE IF EXISTS V20251110190146__Delete_DuplicateEnrollmentEntries $$
DELIMITER ;