DELIMITER $$
DROP PROCEDURE IF EXISTS student_birthday_proc $$
CREATE PROCEDURE student_birthday_proc()
BEGIN
SELECT academy_location.id, concat(persons.mobileCountryCode,persons.mobileNumber) as MobileNo , persons.printName,users.code, academy_location.displayName
FROM students 
JOIN persons on students.personId = persons.Id
JOIN admission on students.userId = admission.studentId
JOIN academy_location on academy_location.id = admission.academyLocationId
JOIN users on users.id = students.userId
where users.status = true AND  DAY(persons.birthDate) = DAY(CURDATE()) and MONTH(persons.birthDate) = MONTH(CURDATE())
GROUP BY academy_location.id,students.userId;
END $$
DELIMITER ;