DELIMITER $$
DROP PROCEDURE IF EXISTS V20251125115702__Create_FinancialInstitutionCsm $$
CREATE PROCEDURE V20251125115702__Create_FinancialInstitutionCsm()
BEGIN

IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='financial_institution_csm')) THEN 
CREATE TABLE `financial_institution_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`code` VARCHAR(255) NOT NULL,
	`name` VARCHAR(255) NOT NULL,
    `status` BIT(1) NOT NULL DEFAULT b'0',
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF; 

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'FINANCIAL_INSTITUTION')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'financial_institution_csm','FINANCIAL_INSTITUTION','Fees & Payments','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;

IF  EXISTS ((select * from standard_master where tableName = 'financial_institution_csm')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'financial_institution_csm');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='NAME')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('name','NAME',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='STATUS')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('status','STATUS',@standardMasterId,'Boolean',NULL,3,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF; 

-- TRANSLATION

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'EMPLOYMENT_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'FINANCIAL_INSTITUTION', 'Financial Institution', 'Financial Institution','Finansiële instelling','Tổ chức tài chính',now(),1);
END IF;
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'EMPLOYMENT_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'CODE', 'code', 'code','kode','Tổ chức tài chính',now(),1);
END IF;
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'EMPLOYMENT_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'NAME', 'name', 'name','naam','TÊN',now(),1);
END IF;
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'EMPLOYMENT_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'STATUS', 'status', 'status','status','trạng thái',now(),1);
END IF;

END $$
CALL V20251125115702__Create_FinancialInstitutionCsm () $$ 
DROP PROCEDURE IF EXISTS V20251125115702__Create_FinancialInstitutionCsm $$ 
DELIMITER ;