DELIMITER $$
DROP PROCEDURE IF EXISTS V20251125180124__Create_loan_header $$
CREATE PROCEDURE V20251125180124__Create_loan_header()
BEGIN

IF NOT EXISTS (
    SELECT * FROM information_schema.TABLES 
    WHERE table_schema = DATABASE() 
      AND table_name = 'loan_header'
) THEN

CREATE TABLE `loan_header` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `studentId` bigint(20) DEFAULT NULL,
    `loanStatus` varchar(50) DEFAULT NULL,
    `loanDate` date DEFAULT NULL,
    `loanAmount` decimal(19,2) DEFAULT NULL,
    `billHeaderId` bigint(20) DEFAULT NULL,
    `programBatchSeatConfigId` bigint(20) DEFAULT NULL,
    `interestRate` decimal(19,2) DEFAULT NULL,
    `subsidy` decimal(19,2) DEFAULT NULL,
    `tenure` bigint(20) DEFAULT NULL,
    `documentId` bigint(20) DEFAULT NULL,
    `financialInstitutionId` bigint(20) DEFAULT NULL,
    `documentName` varchar(255) DEFAULT NULL,
    `addedBy` bigint(20) DEFAULT NULL,
    `loanNumber` varchar(255) DEFAULT NULL,
    `loanAccount` varchar(255) DEFAULT NULL,

    `lastUpdatedBy` bigint(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

    PRIMARY KEY (`id`),

    -- Indexes
    INDEX `fk_loan_header_to_student__idx` (`studentId`),
    INDEX `fk_loan_header_to_bill_header__idx` (`billHeaderId`),
    INDEX `fk_loan_header_to_pbs_config__idx` (`programBatchSeatConfigId`),
    INDEX `fk_loan_header_to_document__idx` (`documentId`),
    INDEX `fk_loan_header_to_financialInstitution__idx` (`financialInstitutionId`),
    INDEX `fk_loan_header_to_user__idx` (`addedBy`),
    INDEX `fk_loan_header_to_last_updated_user__idx` (`lastUpdatedBy`),

    -- Foreign Keys
    CONSTRAINT `fk_loan_header_to_student__idx`
        FOREIGN KEY (`studentId`)
        REFERENCES `students` (`userId`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_loan_header_to_bill_header__idx`
        FOREIGN KEY (`billHeaderId`)
        REFERENCES `bill_header` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_loan_header_to_pbs_config__idx`
        FOREIGN KEY (`programBatchSeatConfigId`)
        REFERENCES `prog_batch_seat_config` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_loan_header_to_document__idx`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,
        
    CONSTRAINT `fk_loan_header_to_financialInstitution__idx`
        FOREIGN KEY (`financialInstitutionId`)
        REFERENCES `financial_institution_csm` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_loan_header_to_user__idx`
        FOREIGN KEY (`addedBy`)
        REFERENCES `users` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_loan_header_to_last_updated_user__idx`
        FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT
);
END IF; 

END $$
CALL V20251125180124__Create_loan_header () $$ 
DROP PROCEDURE IF EXISTS V20251125180124__Create_loan_header $$ 
DELIMITER ;