DELIMITER $$
DROP PROCEDURE IF EXISTS V20251127150937__Create_fees_grant_header $$
CREATE PROCEDURE V20251127150937__Create_fees_grant_header()
BEGIN

IF NOT EXISTS ((
    SELECT * FROM information_schema.TABLES 
    WHERE table_schema = DATABASE() 
      AND table_name = 'fees_grant_header'))
 THEN 
CREATE TABLE `fees_grant_header` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `studentId` bigint(20) DEFAULT NULL,
    `activeStatus` bit(1) DEFAULT NULL,
    `programBatchSeatConfigId` bigint(20) DEFAULT NULL,
    `grantedCU` bigint(20) DEFAULT NULL,
    `availableCU` bigint(20) DEFAULT NULL,
    `totalUsedCU` bigint(20) DEFAULT NULL,
    `startDate` date DEFAULT NULL,
    `endDate` date DEFAULT NULL,
    `documentId` bigint(20) DEFAULT NULL,
    `documentName` varchar(255) DEFAULT NULL,
    `addedBy` bigint(20) DEFAULT NULL,
    `perUnitAmount` decimal(19,2) DEFAULT NULL,
    `lastUpdatedBy` bigint(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

    PRIMARY KEY (`id`),

    -- Indexes
    INDEX `fk_fees_grant_header_to_student__idx` (`studentId`),
    INDEX `fk_fees_grant_header_to_pbs_config__idx` (`programBatchSeatConfigId`),
    INDEX `fk_fees_grant_header_to_document__idx` (`documentId`),
    INDEX `fk_fees_grant_header_to_user__idx` (`addedBy`),
    INDEX `fk_fees_grant_header_to_last_updated_user__idx` (`lastUpdatedBy`),

    -- Foreign Keys
    CONSTRAINT `fk_fees_grant_header_to_student__idx`
        FOREIGN KEY (`studentId`)
        REFERENCES `students` (`userId`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_fees_grant_header_to_pbs_config__idx`
        FOREIGN KEY (`programBatchSeatConfigId`)
        REFERENCES `prog_batch_seat_config` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_fees_grant_header_to_document__idx`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_fees_grant_header_to_user__idx`
        FOREIGN KEY (`addedBy`)
        REFERENCES `users` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_fees_grant_header_to_last_updated_user__idx`
        FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT
);


END IF; 

END $$
CALL V20251127150937__Create_fees_grant_header () $$ 
DROP PROCEDURE IF EXISTS V20251127150937__Create_fees_grant_header $$ 
DELIMITER ;