DELIMITER $$
DROP PROCEDURE IF EXISTS V20251127152952__Create_fees_grant_details $$
CREATE PROCEDURE V20251127152952__Create_fees_grant_details()
BEGIN


IF NOT EXISTS (
    SELECT * FROM information_schema.TABLES 
    WHERE table_schema = DATABASE()
      AND table_name = 'fees_grant_details'
) THEN

CREATE TABLE `fees_grant_details` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,

    `feesGrantHeaderId` bigint(20) DEFAULT NULL,
    `instituteName` varchar(255) DEFAULT NULL,
    `usedCU` bigint(20) DEFAULT NULL,
    `addedBy` bigint(20) DEFAULT NULL,
    `lastUpdatedBy` bigint(20) NOT NULL,
    `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

    PRIMARY KEY (`id`),

    -- Indexes
    INDEX `fk_fees_grant_details_to_header__idx` (`feesGrantHeaderId`),
    INDEX `fk_fees_grant_details_added_by_user__idx` (`addedBy`),
    INDEX `fk_fees_grant_details_last_updated_user__idx` (`lastUpdatedBy`),

    -- Foreign Keys
    CONSTRAINT `fk_fees_grant_details_to_header__idx`
        FOREIGN KEY (`feesGrantHeaderId`)
        REFERENCES `fees_grant_header` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_fees_grant_details_added_by_user__idx`
        FOREIGN KEY (`addedBy`)
        REFERENCES `users` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT,

    CONSTRAINT `fk_fees_grant_details_last_updated_user__idx`
        FOREIGN KEY (`lastUpdatedBy`)
        REFERENCES `users` (`id`)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT
);

END IF; 

END $$
CALL V20251127152952__Create_fees_grant_details () $$ 
DROP PROCEDURE IF EXISTS V20251127152952__Create_fees_grant_details $$ 
DELIMITER ;