DELIMITER $$
DROP PROCEDURE IF EXISTS V20251128150949__Create_NationalService $$
CREATE PROCEDURE V20251128150949__Create_NationalService()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'national_service_detail')) THEN 
CREATE TABLE `national_service_detail` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `applicantPersonId` BIGINT NULL DEFAULT NULL,
  `personId` BIGINT NULL DEFAULT NULL,
  `serviceNameId` BIGINT NULL DEFAULT NULL,
  `statusId` BIGINT NULL DEFAULT NULL,
  `nationalServiceId` VARCHAR(255) NULL DEFAULT NULL,
  `fromDate` DATE NULL DEFAULT NULL,
  `toDate` DATE NULL DEFAULT NULL,
  `documentId` BIGINT NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_national_service_person_idx` (`personId` ASC),
  INDEX `fk_national_service_applicantperson_idx` (`applicantPersonId` ASC),
  INDEX `fk_national_service_idx` (`serviceNameId` ASC)statusId
  INDEX `fk_national_service_status_idx` (`statusId` ASC),
  INDEX `fk_national_service_document_idx` (`documentId` ASC),
  INDEX `fk_national_service_update_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_national_service_person_idx`
    FOREIGN KEY (`personId`)
    REFERENCES `persons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_national_service_applicantperson_idx`
    FOREIGN KEY (`applicantPersonId`)
    REFERENCES `applicant_person` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_national_service_idx`
    FOREIGN KEY (`serviceNameId`)
    REFERENCES `national_service` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
   CONSTRAINT `fk_national_service_status_idx`
    FOREIGN KEY (`statusId`)
    REFERENCES `national_service` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_national_service_document_idx`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_national_service_update_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20251128150949__Create_NationalService () $$ 
DROP PROCEDURE IF EXISTS V20251128150949__Create_NationalService $$ 
DELIMITER ;